/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewWithParts;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.reports.types.GmdPartObjOffen;
import de.cismet.watergis.reports.types.KatasterGewObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.openide.util.Exceptions;

public class GerOffenHelper {
    private List<KatasterGewObj> objList;

    public GerOffenHelper(int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.init(routeIds, allowedWdmArray);
    }

    private void init(int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.objList = this.getAllRoutes(routeIds, allowedWdmArray);
    }

    private List<KatasterGewObj> getAllRoutes(int[] routeIds, int[] allowedWdmArray) throws Exception {
        AllGewWithParts search = new AllGewWithParts(routeIds, allowedWdmArray);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<KatasterGewObj> objList = new ArrayList<KatasterGewObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new KatasterGewObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4)));
            }
        }
        return objList;
    }

    public String getBaCd(int gew) {
        for (KatasterGewObj tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    public String getGewName(int gew) {
        for (KatasterGewObj tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    public Collection<Integer> getGew() {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (KatasterGewObj tmp : this.objList) {
            ts.add(tmp.getId());
        }
        return ts;
    }

    public Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (KatasterGewObj tmp : this.objList) {
            ts.add(tmp.getOwner());
        }
        return ts;
    }

    public Collection<Integer> getWidmung(String gu) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (KatasterGewObj tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu)) continue;
            ts.add(tmp.getWidmung());
        }
        return ts;
    }

    public Collection<Integer> getSb(String gu, Integer wdm) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        return ts;
    }

    public String getGuId(String owner) {
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    public Collection<KatasterGewObj> getAbschnitte() {
        return this.objList;
    }

    public Collection<KatasterGewObj> getAbschnitteOffen() {
        ArrayList<KatasterGewObj> abschnList = new ArrayList<KatasterGewObj>();
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getArt().equals("p")) continue;
            abschnList.add(tmp);
        }
        return abschnList;
    }

    public Collection<KatasterGewObj> getAbschnitteOffen(List<GmdPartObjOffen> profObjects) {
        ArrayList<KatasterGewObj> abschnList = new ArrayList<KatasterGewObj>();
        int profIndex = 0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getArt().equals("p")) continue;
            if (profIndex < profObjects.size() && tmp.getId() == profObjects.get(profIndex).getId().intValue() && profObjects.get(profIndex).isInGewPart(tmp.getId(), tmp.getFrom(), tmp.getTill())) {
                do {
                    GmdPartObjOffen profPart = profObjects.get(profIndex++);
                    if (tmp.getFrom() < profPart.getBaStVon()) {
                        try {
                            KatasterGewObj newObject = tmp.clone();
                            newObject.setTill(profPart.getBaStVon());
                            abschnList.add(newObject);
                            abschnList.add(profPart.toKatasterGewObj());
                            if (!(tmp.getTill() > profPart.getBaStBis())) continue;
                            tmp = tmp.clone();
                            tmp.setFrom(profPart.getBaStBis());
                        }
                        catch (CloneNotSupportedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        continue;
                    }
                    try {
                        abschnList.add(profPart.toKatasterGewObj());
                        if (!(tmp.getTill() > profPart.getBaStBis())) continue;
                        tmp = tmp.clone();
                        tmp.setFrom(profPart.getBaStBis());
                    }
                    catch (CloneNotSupportedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } while (profIndex < profObjects.size() && tmp.getId() == profObjects.get(profIndex).getId().intValue() && profObjects.get(profIndex).isInGewPart(tmp.getId(), tmp.getFrom(), tmp.getTill()));
                continue;
            }
            abschnList.add(tmp);
        }
        return abschnList;
    }

    public int getCountGewAll() {
        return this.getCountGewAll(-1);
    }

    public double getLengthGewAll() {
        return this.getLengthGewAll(-1);
    }

    public int getCountGewAll(int gewId) {
        TreeSet<String> ts = new TreeSet<String>();
        for (KatasterGewObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    public double getLengthGewAll(int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn() {
        return this.getLengthOffeneAbschn(-1);
    }

    public double getLengthOffeneAbschn(int gewId) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    public int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    public double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(String owner, Integer wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm.intValue() || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public int getCountGewAll(String gu) {
        int count = 0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(String gu, Integer wdm) {
        int count = 0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            ++count;
        }
        return count;
    }

    public double getLengthGewAll(String gu) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(String gu, Integer wdm) {
        double length = 0.0;
        for (KatasterGewObj tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            length += tmp.getLength();
        }
        return length;
    }
}

