/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewGeschlBySb;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneGeschlGemeindeReportDialog;
import de.cismet.watergis.gui.dialog.GerinneGeschlSbReportDialog;
import de.cismet.watergis.reports.GerinneGGemeindeReport;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GemeindenDataLightweight;
import de.cismet.watergis.reports.types.SbPartObjGeschl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;

public class GerinneGSbReport
extends GerinneGGemeindeReport {
    private Map<String, List<SbPartObjGeschl>> gemPartMap = new HashMap<String, List<SbPartObjGeschl>>();
    private Map<String, GemeindenDataLightweight> gemDataMap = new HashMap<String, GemeindenDataLightweight>();

    public File createGerinneGewaesserReport(int[] gew) throws Exception {
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        this.parameters.put("datum", df.format(new Date()));
        this.parameters.put("spalte1", false);
        this.parameters.put("spalte2", false);
        this.parameters.put("spalte3", false);
        this.parameters.put("spalte4", false);
        this.parameters.put("spalte5", false);
        this.parameters.put("spalte6", false);
        this.parameters.put("spalte7", false);
        this.parameters.put("spalte8", false);
        this.parameters.put("spalte9", false);
        this.parameters.put("spalte10", false);
        this.parameters.put("spalte11", false);
        this.parameters.put("ges", true);
        this.parameters.put("dimension", GerinneGeschlSbReportDialog.getInstance().getDimensions() != null);
        this.parameters.put("tiefenklasse", GerinneGeschlSbReportDialog.getInstance().getClasses() != null);
        this.parameters.put("fachdata", GerinneGeschlSbReportDialog.getInstance().isAllDataPerObject());
        this.parameters.put("perObject", GerinneGeschlSbReportDialog.getInstance().isPerSb());
        this.parameters.put("sumGu", false);
        this.parameters.put("withWdm", false);
        this.parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneGSbReport.class.getResourceAsStream("/de/cismet/watergis/reports/gerinneGeschlSb.jasper"));
        this.init(gew);
        if (GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getDimensions() != null && GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null && GerinneGeschlGemeindeReportDialog.getInstance().getClasses().size() > 1) {
            this.parameters.put("gemKomp", true);
            dataSources.put("gemeinden", this.getSb2());
        } else if (GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null && GerinneGeschlGemeindeReportDialog.getInstance().getDimensions() != null || GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getDimensions() != null || GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null || GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getDimensions() != null && GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null && GerinneGeschlGemeindeReportDialog.getInstance().getClasses().size() == 1) {
            this.parameters.put("gemKomp", false);
            dataSources.put("gemeinden", this.getSb1());
        } else {
            this.parameters.put("gemKomp", false);
            dataSources.put("gemeinden", this.getSb());
        }
        if (GerinneGeschlSbReportDialog.getInstance().isPerSb()) {
            dataSources.put("objects", this.getObjects());
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)this.parameters, (JRDataSource)dummyDataSource);
        File file = new File(GerinneGeschlSbReportDialog.getInstance().getPath() + "/Schaubezirke.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneGSbReport report = new GerinneGSbReport();
        try {
            report.createReport(new int[]{2}, new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] routeIds) throws Exception {
        List<SbPartObjGeschl> objectList = this.getAllRoutes(routeIds);
        for (SbPartObjGeschl obj : objectList) {
            List<SbPartObjGeschl> sbList = this.gemPartMap.get(obj.getNr_li());
            if (sbList == null) {
                sbList = new ArrayList<SbPartObjGeschl>();
                this.gemPartMap.put(obj.getNr_li(), sbList);
            }
            sbList.add(obj);
        }
        for (String sb : this.gemPartMap.keySet()) {
            Integer[] idList = this.getGew(sb).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.gemDataMap.put(sb, new GemeindenDataLightweight(1, routes));
        }
    }

    private List<SbPartObjGeschl> getAllRoutes(int[] routeIds) throws Exception {
        AllGewGeschlBySb search = new AllGewGeschlBySb(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<SbPartObjGeschl> objList = new ArrayList<SbPartObjGeschl>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new SbPartObjGeschl((Integer)f.get(0), (String)f.get(7), (String)f.get(1), (String)f.get(4), (String)f.get(2), (Integer)f.get(3), (String)f.get(8), (Double)f.get(9), (Double)f.get(10), (String)f.get(11), (String)f.get(12), (Double)f.get(5), (Double)f.get(6), (String)f.get(13), (String)f.get(14), (String)f.get(15), (String)f.get(16), (String)f.get(17), (Integer)f.get(18), (String)f.get(19), (String)f.get(20), (String)f.get(21), (Double)f.get(22), (Double)f.get(23), (Double)f.get(24), (Double)f.get(25), (Double)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (Double)f.get(31), (Double)f.get(32), (String)f.get(33), (String)f.get(34)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneGeschlSbReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneGeschlSbReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneGeschlSbReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneGeschlSbReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneGeschlSbReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getSb() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        String art = this.createArtString();
        for (String sb : this.gemDataMap.keySet()) {
            double colLength;
            double colCount;
            String lab;
            String anz;
            Integer till;
            Integer from;
            int i;
            List<Object> l;
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double count = 0.0;
            double length = 0.0;
            feature.put("anzahlGmd", this.gemDataMap.size());
            feature.put("group", "gemeinde");
            feature.put("gmdNr", sb);
            feature.put("gmdName", this.gemDataMap.get(sb).getGmdName());
            feature.put("art", art);
            if (GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null) {
                l = GerinneGeschlGemeindeReportDialog.getInstance().getClasses();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + i;
                    String laenge = "laenge" + i;
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllTf(sb, from, till);
                    colLength = this.getLengthAllTf(sb, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGemeindeReportDialog.getInstance().getDimensions() != null) {
                l = GerinneGeschlGemeindeReportDialog.getInstance().getDimensions();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllDim(sb, from, till);
                    colLength = this.getLengthAllDim(sb, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null) {
                l = GerinneGeschlGemeindeReportDialog.getInstance().getArt();
                for (i = 0; i < l.size(); ++i) {
                    String anz2 = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    String lab2 = "lab" + (i + 1);
                    double colCount2 = this.getCount(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    double colLength2 = this.getLength(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    count += colCount2;
                    length += colLength2;
                    feature.put(lab2, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                    feature.put(anz2, colCount2);
                    feature.put(laenge, colLength2);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    if (GerinneGeschlGemeindeReportDialog.getInstance().getArt().size() == 1) {
                        this.parameters.put("ges", false);
                    }
                    first = false;
                }
            }
            feature.put("anzGes", count);
            feature.put("laengeGes", length);
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getSb1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null && GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlGemeindeReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlGemeindeReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        for (int di = 0; di < d.size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            for (String sb : this.gemDataMap.keySet()) {
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                feature.put("anzahlGmd", this.gemDataMap.size());
                feature.put("group", null);
                feature.put("gmdNr", sb);
                feature.put("gmdName", this.gemDataMap.get(sb).getGmdName());
                feature.put("art", art);
                if (!isTiefeArt && GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlGemeindeReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        Integer till = (Integer)l.get(i);
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        String lab = "lab" + (i + 1);
                        if (GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null && GerinneGeschlGemeindeReportDialog.getInstance().getArt().size() == 1) {
                            GerinneGeschlGemeindeReportDialog.Art arten = GerinneGeschlGemeindeReportDialog.getInstance().getArt().get(0);
                            colCount = this.getCountAllTfDim(sb, arten, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(sb, arten, from, till, dimFrom, dimTill);
                        } else {
                            colCount = this.getCountAllTfDim(sb, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(sb, from, till, dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlGemeindeReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlGemeindeReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        String anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab = "lab" + (i + 1);
                        if (isTiefeArt) {
                            colCount = this.getCountTf(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthTf(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        } else {
                            colCount = this.getCountDim(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthDim(sb, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlGemeindeReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        features.add(this.createKumFeature(featuresKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getSb2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        boolean first = true;
        String art = this.createArtString();
        for (int di = 0; di < GerinneGeschlGemeindeReportDialog.getInstance().getDimensions().size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            List<Integer> d = GerinneGeschlGemeindeReportDialog.getInstance().getDimensions();
            for (String sb : this.gemDataMap.keySet()) {
                Integer till;
                Integer from;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("anzahlGmd", this.gemDataMap.size());
                feature.put("group", null);
                feature.put("gmdNr", sb);
                feature.put("gmdName", this.gemDataMap.get(sb).getGmdName());
                feature.put("art", art);
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGemeindeReportDialog.getInstance().getArt()) {
                    double countA = 0.0;
                    double lengthA = 0.0;
                    if (GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null) {
                        int i;
                        List<Integer> l = GerinneGeschlGemeindeReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                            String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                            String lab = "lab" + (i + 1);
                            double colCount = this.getCountAllTfDim(sb, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(sb, a, from, till, dimFrom, dimTill);
                            count += colCount;
                            length += colLength;
                            countA += colCount;
                            lengthA += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    }
                    feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                    feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                if (GerinneGeschlGemeindeReportDialog.getInstance().getClasses() != null) {
                    List<Integer> l = GerinneGeschlGemeindeReportDialog.getInstance().getClasses();
                    double countT = 0.0;
                    double lengthT = 0.0;
                    for (int i = 0; i < l.size(); ++i) {
                        for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGemeindeReportDialog.getInstance().getArt()) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            double colCount = this.getCountAllTfDim(sb, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(sb, a, from, till, dimFrom, dimTill);
                            countT += colCount;
                            lengthT += colLength;
                        }
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        feature.put(anz, countT);
                        feature.put(laenge, lengthT);
                    }
                }
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        features.add(this.createKumFeature(featuresKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getObjects() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        for (String sb : this.gemDataMap.keySet()) {
            this.sheetNames.add("Objekte " + this.gemDataMap.get(sb).getGmdName());
            for (Integer gew : this.getGew(sb)) {
                for (SbPartObjGeschl obj : this.getObjects(sb, gew)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    feature.put("group", String.valueOf(sb));
                    feature.put("gmdNr", sb);
                    feature.put("gmdName", this.gemDataMap.get(sb).getGmdName());
                    feature.put("gewName", this.getGewName(sb, gew));
                    feature.put("code", this.getBaCd(sb, gew));
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(sb, gew));
                    feature.put("von", this.convertStation(obj.getFrom()));
                    feature.put("bis", this.convertStation(obj.getTill()));
                    feature.put("anzahlObj", this.getObjects(sb, gew).size());
                    feature.put("tf", this.getTf(obj.getTf()));
                    feature.put("dim", this.getDim(obj.getDim()));
                    feature.put("ls", obj.getLs());
                    feature.put("prof", obj.getProf());
                    feature.put("ma", obj.getMa());
                    feature.put("objNr", obj.getObjNr());
                    feature.put("tr", obj.getTr());
                    feature.put("ausbaujahr", obj.getAusbaujahr());
                    feature.put("wbbl", obj.getWbbl());
                    feature.put("art", obj.getArt());
                    feature.put("laengeObj", obj.getLength());
                    feature.put("faktor", obj.getLs());
                    feature.put("zustKl", obj.getLs());
                    feature.put("br", obj.getLs());
                    feature.put("brOben", obj.getBrOben());
                    feature.put("hoehe", obj.getHoehe());
                    feature.put("hEin", obj.gethEin());
                    feature.put("hAus", obj.gethAus());
                    feature.put("gefaelle", obj.getGefaelle());
                    feature.put("dhAus", obj.getDhAus());
                    feature.put("dhEin", obj.getDhEin());
                    feature.put("hAb", obj.gethAb());
                    feature.put("hAuf", obj.gethAuf());
                    feature.put("aufstieg", obj.getAufstieg());
                    features.add(feature);
                }
            }
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private Collection<Integer> getGew(String sbNr) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbPartObjGeschl tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<SbPartObjGeschl> getObjects(String sbKu, int gew) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        TreeSet<SbPartObjGeschl> ts = new TreeSet<SbPartObjGeschl>();
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            ts.add(tmp);
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu(String sbKu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        TreeSet<String> ts = new TreeSet<String>();
        for (SbPartObjGeschl tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private Collection<Integer> getWdm(String sbKu, String gu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ts.add(tmp.getWidmung());
        }
        return ts.descendingSet();
    }

    @Override
    protected boolean valueBetween(Double value, Integer from, Integer till) {
        if (value == null && till == null) {
            return true;
        }
        if (value == null || till == null) {
            return false;
        }
        Integer fromConvert = from == null ? 0 : from;
        return value > (double)fromConvert.intValue() && value <= (double)till.intValue();
    }

    private double getCountAllDim(String sbKu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String sbKu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String sbKu, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String sbKu, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(String sbKu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String sbKu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(String sbKu, int gew, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String sbKu, int gew, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(String sbKu, String gu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String sbKu, String gu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(String sbKu, String gu, Integer wdm, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String sbKu, String gu, Integer wdm, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(String sbKu, int gew, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String sbKu, int gew, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(String sbKu, String gu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String sbKu, String gu, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(String sbKu, String gu, Integer wdm, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String sbKu, String gu, Integer wdm, Integer from, Integer till) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String sbKu, String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (String sbKu : this.gemPartMap.keySet()) {
            List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
            for (SbPartObjGeschl tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.size();
    }

    private String getBaCd(String sbKu, int gew) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(String sbKu, int gew) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll(String sbKu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        TreeSet<String> ts = new TreeSet<String>();
        for (SbPartObjGeschl tmp : gemList) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll(String sbKu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String sbKu, int gewId) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String sbKu, String gu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, Integer wdm) {
        double length = 0.0;
        for (String sbKu : this.gemPartMap.keySet()) {
            List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
            for (SbPartObjGeschl tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(String sbKu, String gu) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        int count = 0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, Integer wdm) {
        int count = 0;
        for (String sbKu : this.gemPartMap.keySet()) {
            List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
            for (SbPartObjGeschl tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGew(String sbKu, String gu, int wdm) {
        List<SbPartObjGeschl> gemList = this.gemPartMap.get(sbKu);
        double length = 0.0;
        for (SbPartObjGeschl tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    @Override
    protected String createArtString() {
        String art;
        if (GerinneGeschlSbReportDialog.getInstance().getArt() == null) {
            art = "RL-D-Due";
        } else {
            art = null;
            for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlSbReportDialog.getInstance().getArt()) {
                if (art == null) {
                    art = a.name();
                    continue;
                }
                art = art + "-" + a.name();
            }
        }
        return art;
    }
}

