/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewOffenByGem;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneOGemeindeReportDialog;
import de.cismet.watergis.reports.GerOffenGmdHelper;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GemeindenDataLightweight;
import de.cismet.watergis.reports.types.GmdPartObj;
import de.cismet.watergis.reports.types.GmdPartObjOffen;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.log4j.Logger;

public class GerinneOGemeindeReport {
    private static final Logger LOG = Logger.getLogger(GerinneOGemeindeReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu"};
    private static final int PROFSTAT = 1;
    private final Map<Integer, List<GmdPartObjOffen>> gemPartMap = new HashMap<Integer, List<GmdPartObjOffen>>();
    private final Map<Integer, GemeindenDataLightweight> gemDataMap = new HashMap<Integer, GemeindenDataLightweight>();
    private final List<String> sheetNames = new ArrayList<String>();
    private GerOffenGmdHelper helper;

    public File createGemeindeReport(int[] gemId, int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("gemeinden", gemId.length);
        parameters.put("perGew", GerinneOGemeindeReportDialog.getInstance().isPerGew());
        parameters.put("perAbschn", GerinneOGemeindeReportDialog.getInstance().isPerPart());
        parameters.put("sumGu", GerinneOGemeindeReportDialog.getInstance().isSumGu());
        parameters.put("wdm", GerinneOGemeindeReportDialog.getInstance().isPerWdm());
        parameters.put("perAbschnProf", GerinneOGemeindeReportDialog.getInstance().isPerPartProf());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneOGemeindeReport.class.getResourceAsStream("/de/cismet/watergis/reports/GerinneOffenGem.jasper"));
        this.init(gemId, gew);
        this.helper = new GerOffenGmdHelper(gemId, gew, this.getAllowedWdms());
        dataSources.put("gemeinden", this.getGemeindenAll());
        if (GerinneOGemeindeReportDialog.getInstance().isPerGew() && !GerinneOGemeindeReportDialog.getInstance().isPerPart() && !GerinneOGemeindeReportDialog.getInstance().isPerPartProf()) {
            dataSources.put("gewaesser", this.getGewaesser());
        } else if (GerinneOGemeindeReportDialog.getInstance().isPerPartProf()) {
            dataSources.put("gewaesserAbschnittProf", this.getGewaesserAbschnittProfil());
        } else if (GerinneOGemeindeReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschnitt", this.getGewaesserAbschnitt());
        }
        if (GerinneOGemeindeReportDialog.getInstance().isSumGu()) {
            if (GerinneOGemeindeReportDialog.getInstance().isPerWdm()) {
                dataSources.put("gewaesserGuAbschnitt", this.getGewaesserGuWidmung());
            } else {
                dataSources.put("gewaesserGu", this.getGewaesserGu());
            }
        }
        File file = new File(GerinneOGemeindeReportDialog.getInstance().getPath() + "/Gerinne_offen_Gemeinden.xls");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsReportConfiguration config = new SimpleXlsReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneOGemeindeReport report = new GerinneOGemeindeReport();
        try {
            report.createGemeindeReport(new int[]{2}, new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] gemNr, int[] routeIds) throws Exception {
        for (int gem : gemNr) {
            this.gemPartMap.put(gem, this.getAllRoutes(gem, routeIds));
            Integer[] idList = this.getGew(gem).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            this.gemDataMap.put(gem, new GemeindenDataLightweight(gem, routes));
        }
    }

    private List<GmdPartObjOffen> getAllRoutes(int gemId, int[] routeIds) throws Exception {
        AllGewOffenByGem search = new AllGewOffenByGem(gemId, routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObjOffen> objList = new ArrayList<GmdPartObjOffen>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObjOffen((Integer)f.get(0), (String)f.get(1), (String)f.get(2), (Integer)f.get(3), (String)f.get(4), (String)f.get(5), (Double)f.get(6), (Double)f.get(7), (Integer)f.get(8), (Integer)f.get(9), (String)f.get(10), (Double)f.get(11), (Double)f.get(12), (Double)f.get(13), (Double)f.get(14), (Double)f.get(15), (Double)f.get(16), (Double)f.get(17), (Double)f.get(18), (Double)f.get(19), (Double)f.get(20), (Double)f.get(21), (Double)f.get(22), (String)f.get(23), (Double)f.get(24), (Double)f.get(25), (String)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (String)f.get(31), (Double)f.get(32), (Integer)f.get(33), (Double)f.get(34), (Double)f.get(35), (Double)f.get(36), (Double)f.get(37), (Double)f.get(38), (Double)f.get(39), (Double)f.get(40), (Double)f.get(41), (Double)f.get(42), (Double)f.get(43), (Double)f.get(44), (Double)f.get(45), (Double)f.get(46), (Double)f.get(47), (Double)f.get(48), (String)f.get(49)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneOGemeindeReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneOGemeindeReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneOGemeindeReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneOGemeindeReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneOGemeindeReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGemeindenAll() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        for (Integer gem : this.gemDataMap.keySet()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double offenLength = this.helper.getLengthOffeneAbschn(gem);
            double prof = this.getLengthGew(gem);
            double mw = this.getLengthMw(gem);
            double gewAll = this.helper.getLengthGewAll(gem);
            feature.put("name", this.gemDataMap.get(gem).getGmdName());
            feature.put("nummer", gem);
            feature.put("gew_a", this.helper.getCountGewAll(gem));
            feature.put("gew_l", this.helper.getLengthGewAll(gem));
            feature.put("offene_l", offenLength);
            feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
            feature.put("prof_l", prof);
            feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
            feature.put("mw_l", mw);
            feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
            feature.put("profTrap_a", this.getCountProf("tr", gem));
            feature.put("profTrap_l", this.getLengthProf("tr", gem));
            feature.put("profRe_a", this.getCountProf("re", gem));
            feature.put("profRe_l", this.getLengthProf("re", gem));
            feature.put("brSohleMin", this.getMinMax("brSo", gem, true));
            feature.put("brSohleMit", this.getMit("brSo", gem));
            feature.put("brSohleMax", this.getMinMax("brSo", gem, false));
            feature.put("bvReMin", this.getMinMax("bvRe", gem, true));
            feature.put("bvReMit", this.getMit("bvRe", gem));
            feature.put("bvReMax", this.getMinMax("bvRe", gem, false));
            feature.put("bhReMin", this.getMinMax("bhRe", gem, true));
            feature.put("bhReMit", this.getMit("bhRe", gem));
            feature.put("bhReMax", this.getMinMax("bhRe", gem, false));
            feature.put("blReMin", this.getMinMax("blRe", gem, true));
            feature.put("blReMit", this.getMit("blRe", gem));
            feature.put("blReMax", this.getMinMax("blRe", gem, false));
            feature.put("bvLiMin", this.getMinMax("bvLi", gem, true));
            feature.put("bvLiMit", this.getMit("bvLi", gem));
            feature.put("bvLiMax", this.getMinMax("bvLi", gem, false));
            feature.put("bhLiMin", this.getMinMax("bhLi", gem, true));
            feature.put("bhLiMit", this.getMit("bhLi", gem));
            feature.put("bhLiMax", this.getMinMax("bhLi", gem, false));
            feature.put("blLiMin", this.getMinMax("blLi", gem, true));
            feature.put("blLiMit", this.getMit("blLi", gem));
            feature.put("blLiMax", this.getMinMax("blLi", gem, false));
            feature.put("flSohle", this.getSum("flSo", gem));
            feature.put("flBoeRe", this.getSum("flBRe", gem));
            feature.put("flBoeLi", this.getSum("flBLi", gem));
            feature.put("flBoe", this.getSum("flB", gem));
            feature.put("flGer", this.getSum("flGer", gem));
            feature.put("brGewMin", this.getMinMax("brGew", gem, true));
            feature.put("brGewMit", this.getMit("brGew", gem));
            feature.put("brGewMax", this.getMinMax("brGew", gem, false));
            feature.put("flGew", this.getSum("flGew", gem));
            feature.put("blNassReMin", this.getMinMax("blNRe", gem, true));
            feature.put("blNassReMit", this.getMit("blNRe", gem));
            feature.put("blNassReMax", this.getMinMax("blNRe", gem, false));
            feature.put("blTroReMin", this.getMinMax("blTRe", gem, true));
            feature.put("blTroReMit", this.getMit("blTRe", gem));
            feature.put("blTroReMax", this.getMinMax("blTRe", gem, false));
            feature.put("blNassLiMin", this.getMinMax("blNLi", gem, true));
            feature.put("blNassLiMit", this.getMit("blNLi", gem));
            feature.put("blNassLiMax", this.getMinMax("blNLi", gem, false));
            feature.put("blTroLiMin", this.getMinMax("blTLi", gem, true));
            feature.put("blTroLiMit", this.getMit("blTLi", gem));
            feature.put("blTroLiMax", this.getMinMax("blTLi", gem, false));
            feature.put("flBoeNassRe", this.getSum("flBnRe", gem));
            feature.put("flBoeTroRe", this.getSum("flBtRe", gem));
            feature.put("flBoeNassLi", this.getSum("flBnLi", gem));
            feature.put("flBoeTroLi", this.getSum("flBtLi", gem));
            feature.put("flBoeNass", this.getSum("flBn", gem));
            feature.put("flBoeTro", this.getSum("flBt", gem));
            feature.put("flNass", this.getSum("flN", gem));
            feature.put("summe", false);
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            if (this.getGew(gem) == null || this.getGew(gem).isEmpty()) continue;
            this.sheetNames.add(this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (int gew : this.getGew(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double offenLength = this.helper.getLengthOffeneAbschn((int)gem, gew);
                double prof = this.getLengthGew((int)gem, gew);
                double mw = this.getLengthMw((int)gem, gew);
                double gewAll = this.helper.getLengthGewAll((int)gem, gew);
                feature.put("name", this.getGewName(gem, gew));
                feature.put("code", this.getBaCd(gem, gew));
                feature.put("gew_l", this.helper.getLengthGewAll((int)gem, gew));
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", (int)gem, gew));
                feature.put("profTrap_l", this.getLengthProf("tr", (int)gem, gew));
                feature.put("profRe_a", this.getCountProf("re", (int)gem, gew));
                feature.put("profRe_l", this.getLengthProf("re", (int)gem, gew));
                feature.put("brSohleMin", this.getMinMax("brSo", (int)gem, gew, true));
                feature.put("brSohleMit", this.getMit("brSo", (int)gem, gew));
                feature.put("brSohleMax", this.getMinMax("brSo", (int)gem, gew, false));
                feature.put("bvReMin", this.getMinMax("bvRe", (int)gem, gew, true));
                feature.put("bvReMit", this.getMit("bvRe", (int)gem, gew));
                feature.put("bvReMax", this.getMinMax("bvRe", (int)gem, gew, false));
                feature.put("bhReMin", this.getMinMax("bhRe", (int)gem, gew, true));
                feature.put("bhReMit", this.getMit("bhRe", (int)gem, gew));
                feature.put("bhReMax", this.getMinMax("bhRe", (int)gem, gew, false));
                feature.put("blReMin", this.getMinMax("blRe", (int)gem, gew, true));
                feature.put("blReMit", this.getMit("blRe", (int)gem, gew));
                feature.put("blReMax", this.getMinMax("blRe", (int)gem, gew, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", (int)gem, gew, true));
                feature.put("bvLiMit", this.getMit("bvLi", (int)gem, gew));
                feature.put("bvLiMax", this.getMinMax("bvLi", (int)gem, gew, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", (int)gem, gew, true));
                feature.put("bhLiMit", this.getMit("bhLi", (int)gem, gew));
                feature.put("bhLiMax", this.getMinMax("bhLi", (int)gem, gew, false));
                feature.put("blLiMin", this.getMinMax("blLi", (int)gem, gew, true));
                feature.put("blLiMit", this.getMit("blLi", (int)gem, gew));
                feature.put("blLiMax", this.getMinMax("blLi", (int)gem, gew, false));
                feature.put("flSohle", this.getSum("flSo", (int)gem, gew));
                feature.put("flBoeRe", this.getSum("flBRe", (int)gem, gew));
                feature.put("flBoeLi", this.getSum("flBLi", (int)gem, gew));
                feature.put("flBoe", this.getSum("flB", (int)gem, gew));
                feature.put("flGer", this.getSum("flGer", (int)gem, gew));
                feature.put("brGewMin", this.getMinMax("brGew", (int)gem, gew, true));
                feature.put("brGewMit", this.getMit("brGew", (int)gem, gew));
                feature.put("brGewMax", this.getMinMax("brGew", (int)gem, gew, false));
                feature.put("flGew", this.getSum("flGew", (int)gem, gew));
                feature.put("blNassReMin", this.getMinMax("blNRe", (int)gem, gew, true));
                feature.put("blNassReMit", this.getMit("blNRe", (int)gem, gew));
                feature.put("blNassReMax", this.getMinMax("blNRe", (int)gem, gew, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", (int)gem, gew, true));
                feature.put("blTroReMit", this.getMit("blTRe", (int)gem, gew));
                feature.put("blTroReMax", this.getMinMax("blTRe", (int)gem, gew, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", (int)gem, gew, true));
                feature.put("blNassLiMit", this.getMit("blNLi", (int)gem, gew));
                feature.put("blNassLiMax", this.getMinMax("blNLi", (int)gem, gew, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", (int)gem, gew, true));
                feature.put("blTroLiMit", this.getMit("blTLi", (int)gem, gew));
                feature.put("blTroLiMax", this.getMinMax("blTLi", (int)gem, gew, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", (int)gem, gew, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", (int)gem, gew));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", (int)gem, gew, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", (int)gem, gew, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", (int)gem, gew));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", (int)gem, gew, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", (int)gem, gew));
                feature.put("flBoeTroRe", this.getSum("flBtRe", (int)gem, gew));
                feature.put("flBoeNassLi", this.getSum("flBnLi", (int)gem, gew));
                feature.put("flBoeTroLi", this.getSum("flBtLi", (int)gem, gew));
                feature.put("flBoeNass", this.getSum("flBn", (int)gem, gew));
                feature.put("flBoeTro", this.getSum("flBt", (int)gem, gew));
                feature.put("flNass", this.getSum("flN", (int)gem, gew));
                feature.put("summe", false);
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            if (this.helper.getGemPartMap().get(gem) == null || this.helper.getGemPartMap().get(gem).isEmpty()) continue;
            this.sheetNames.add(this.gemDataMap.get(gem).getGmdName());
            for (GmdPartObj gew : this.helper.getGemPartMap().get(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                int id = gew.getId();
                double from = gew.getFrom();
                double till = gew.getTill();
                double offenLength = this.helper.getLengthOffeneAbschn(gem, id, from, till);
                double prof = this.getLengthGew(gem, id, from, till);
                double mw = this.getLengthMw(gem, id, from, till);
                double gewAll = this.helper.getLengthGewAll((int)gem, id);
                feature.put("name", this.getGewName(gem, id));
                feature.put("code", this.getBaCd(gem, id));
                feature.put("gew_l", this.helper.getLengthGewAll((int)gem, id));
                feature.put("von", this.convertStation(from));
                feature.put("bis", this.convertStation(till));
                feature.put("laenge", gew.getLength());
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", gem, id, from, till));
                feature.put("profTrap_l", this.getLengthProf("tr", gem, id, from, till));
                feature.put("profRe_a", this.getCountProf("re", gem, id, from, till));
                feature.put("profRe_l", this.getLengthProf("re", gem, id, from, till));
                feature.put("brSohleMin", this.getMinMax("brSo", gem, id, from, till, true));
                feature.put("brSohleMit", this.getMit("brSo", gem, id, from, till));
                feature.put("brSohleMax", this.getMinMax("brSo", gem, id, from, till, false));
                feature.put("bvReMin", this.getMinMax("bvRe", gem, id, from, till, true));
                feature.put("bvReMit", this.getMit("bvRe", gem, id, from, till));
                feature.put("bvReMax", this.getMinMax("bvRe", gem, id, from, till, false));
                feature.put("bhReMin", this.getMinMax("bhRe", gem, id, from, till, true));
                feature.put("bhReMit", this.getMit("bhRe", gem, id, from, till));
                feature.put("bhReMax", this.getMinMax("bhRe", gem, id, from, till, false));
                feature.put("blReMin", this.getMinMax("blRe", gem, id, from, till, true));
                feature.put("blReMit", this.getMit("blRe", gem, id, from, till));
                feature.put("blReMax", this.getMinMax("blRe", gem, id, from, till, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", gem, id, from, till, true));
                feature.put("bvLiMit", this.getMit("bvLi", gem, id, from, till));
                feature.put("bvLiMax", this.getMinMax("bvLi", gem, id, from, till, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", gem, id, from, till, true));
                feature.put("bhLiMit", this.getMit("bhLi", gem, id, from, till));
                feature.put("bhLiMax", this.getMinMax("bhLi", gem, id, from, till, false));
                feature.put("blLiMin", this.getMinMax("blLi", gem, id, from, till, true));
                feature.put("blLiMit", this.getMit("blLi", gem, id, from, till));
                feature.put("blLiMax", this.getMinMax("blLi", gem, id, from, till, false));
                feature.put("flSohle", this.getSum("flSo", gem, id, from, till));
                feature.put("flBoeRe", this.getSum("flBRe", gem, id, from, till));
                feature.put("flBoeLi", this.getSum("flBLi", gem, id, from, till));
                feature.put("flBoe", this.getSum("flB", gem, id, from, till));
                feature.put("flGer", this.getSum("flGer", gem, id, from, till));
                feature.put("brGewMin", this.getMinMax("brGew", gem, id, from, till, true));
                feature.put("brGewMit", this.getMit("brGew", gem, id, from, till));
                feature.put("brGewMax", this.getMinMax("brGew", gem, id, from, till, false));
                feature.put("flGew", this.getSum("flGew", gem, id, from, till));
                feature.put("blNassReMin", this.getMinMax("blNRe", gem, id, from, till, true));
                feature.put("blNassReMit", this.getMit("blNRe", gem, id, from, till));
                feature.put("blNassReMax", this.getMinMax("blNRe", gem, id, from, till, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", gem, id, from, till, true));
                feature.put("blTroReMit", this.getMit("blTRe", gem, id, from, till));
                feature.put("blTroReMax", this.getMinMax("blTRe", gem, id, from, till, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", gem, id, from, till, true));
                feature.put("blNassLiMit", this.getMit("blNLi", gem, id, from, till));
                feature.put("blNassLiMax", this.getMinMax("blNLi", gem, id, from, till, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", gem, id, from, till, true));
                feature.put("blTroLiMit", this.getMit("blTLi", gem, id, from, till));
                feature.put("blTroLiMax", this.getMinMax("blTLi", gem, id, from, till, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", gem, id, from, till, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", gem, id, from, till));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", gem, id, from, till, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", gem, id, from, till, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", gem, id, from, till));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", gem, id, from, till, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", gem, id, from, till));
                feature.put("flBoeTroRe", this.getSum("flBtRe", gem, id, from, till));
                feature.put("flBoeNassLi", this.getSum("flBnLi", gem, id, from, till));
                feature.put("flBoeTroLi", this.getSum("flBtLi", gem, id, from, till));
                feature.put("flBoeNass", this.getSum("flBn", gem, id, from, till));
                feature.put("flBoeTro", this.getSum("flBt", gem, id, from, till));
                feature.put("flNass", this.getSum("flN", gem, id, from, till));
                feature.put("summe", false);
                String newCode = this.getBaCd(gem, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    features.add(this.createKumFeature(featureListGewKum, true));
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(feature);
                featureListKum.add(feature);
                featureListGewKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnittProfil() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            if (this.gemPartMap.get(gem) == null || this.gemPartMap.get(gem).isEmpty()) continue;
            this.sheetNames.add(this.gemDataMap.get(gem).getGmdName());
            for (GmdPartObjOffen gew : this.gemPartMap.get(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                int id = gew.getId();
                double from = gew.getBaStVon();
                double till = gew.getBaStBis();
                double offenLength = this.helper.getLengthOffeneAbschn(gem, id, from, till);
                double prof = this.getLengthGew(gem, id, from, till);
                double mw = this.getLengthMw(gem, id, from, till);
                double gewAll = this.helper.getLengthGewAll((int)gem, id);
                feature.put("group", this.gemDataMap.get(gem).getGmdName());
                feature.put("name", this.getGewName(gem, id));
                feature.put("code", this.getBaCd(gem, id));
                feature.put("gew_l", gewAll);
                feature.put("von", this.convertStation(from));
                feature.put("bis", this.convertStation(till));
                feature.put("laenge", gew.getLength());
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", gem, id, from, till));
                feature.put("profTrap_l", this.getLengthProf("tr", gem, id, from, till));
                feature.put("profRe_a", this.getCountProf("re", gem, id, from, till));
                feature.put("profRe_l", this.getLengthProf("re", gem, id, from, till));
                feature.put("brSohleMin", this.getMinMax("brSo", gem, id, from, till, true));
                feature.put("brSohleMit", this.getMit("brSo", gem, id, from, till));
                feature.put("brSohleMax", this.getMinMax("brSo", gem, id, from, till, false));
                feature.put("bvReMin", this.getMinMax("bvRe", gem, id, from, till, true));
                feature.put("bvReMit", this.getMit("bvRe", gem, id, from, till));
                feature.put("bvReMax", this.getMinMax("bvRe", gem, id, from, till, false));
                feature.put("bhReMin", this.getMinMax("bhRe", gem, id, from, till, true));
                feature.put("bhReMit", this.getMit("bhRe", gem, id, from, till));
                feature.put("bhReMax", this.getMinMax("bhRe", gem, id, from, till, false));
                feature.put("blReMin", this.getMinMax("blRe", gem, id, from, till, true));
                feature.put("blReMit", this.getMit("blRe", gem, id, from, till));
                feature.put("blReMax", this.getMinMax("blRe", gem, id, from, till, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", gem, id, from, till, true));
                feature.put("bvLiMit", this.getMit("bvLi", gem, id, from, till));
                feature.put("bvLiMax", this.getMinMax("bvLi", gem, id, from, till, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", gem, id, from, till, true));
                feature.put("bhLiMit", this.getMit("bhLi", gem, id, from, till));
                feature.put("bhLiMax", this.getMinMax("bhLi", gem, id, from, till, false));
                feature.put("blLiMin", this.getMinMax("blLi", gem, id, from, till, true));
                feature.put("blLiMit", this.getMit("blLi", gem, id, from, till));
                feature.put("blLiMax", this.getMinMax("blLi", gem, id, from, till, false));
                feature.put("flSohle", this.getSum("flSo", gem, id, from, till));
                feature.put("flBoeRe", this.getSum("flBRe", gem, id, from, till));
                feature.put("flBoeLi", this.getSum("flBLi", gem, id, from, till));
                feature.put("flBoe", this.getSum("flB", gem, id, from, till));
                feature.put("flGer", this.getSum("flGer", gem, id, from, till));
                feature.put("brGewMin", this.getMinMax("brGew", gem, id, from, till, true));
                feature.put("brGewMit", this.getMit("brGew", gem, id, from, till));
                feature.put("brGewMax", this.getMinMax("brGew", gem, id, from, till, false));
                feature.put("flGew", this.getSum("flGew", gem, id, from, till));
                feature.put("blNassReMin", this.getMinMax("blNRe", gem, id, from, till, true));
                feature.put("blNassReMit", this.getMit("blNRe", gem, id, from, till));
                feature.put("blNassReMax", this.getMinMax("blNRe", gem, id, from, till, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", gem, id, from, till, true));
                feature.put("blTroReMit", this.getMit("blTRe", gem, id, from, till));
                feature.put("blTroReMax", this.getMinMax("blTRe", gem, id, from, till, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", gem, id, from, till, true));
                feature.put("blNassLiMit", this.getMit("blNLi", gem, id, from, till));
                feature.put("blNassLiMax", this.getMinMax("blNLi", gem, id, from, till, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", gem, id, from, till, true));
                feature.put("blTroLiMit", this.getMit("blTLi", gem, id, from, till));
                feature.put("blTroLiMax", this.getMinMax("blTLi", gem, id, from, till, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", gem, id, from, till, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", gem, id, from, till));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", gem, id, from, till, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", gem, id, from, till, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", gem, id, from, till));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", gem, id, from, till, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", gem, id, from, till));
                feature.put("flBoeTroRe", this.getSum("flBtRe", gem, id, from, till));
                feature.put("flBoeNassLi", this.getSum("flBnLi", gem, id, from, till));
                feature.put("flBoeTroLi", this.getSum("flBtLi", gem, id, from, till));
                feature.put("flBoeNass", this.getSum("flBn", gem, id, from, till));
                feature.put("flBoeTro", this.getSum("flBt", gem, id, from, till));
                feature.put("flNass", this.getSum("flN", gem, id, from, till));
                feature.put("summe", false);
                String newCode = this.getBaCd(gem, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    features.add(this.createKumFeature(featureListGewKum, true));
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(feature);
                featureListKum.add(feature);
                featureListGewKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false, 1));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGu() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            if (this.getGu(gem) == null || this.getGu(gem).isEmpty()) continue;
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double offenLength = this.helper.getLengthOffeneAbschn((int)gem, guName);
                double prof = this.getLengthGew((int)gem, guName);
                double mw = this.getLengthMw((int)gem, guName);
                double gewAll = this.helper.getLengthGewAll((int)gem, guName);
                feature.put("group", String.valueOf(gem));
                feature.put("name", guName);
                feature.put("gu", this.getGuId(gem, guName));
                feature.put("gew_a", this.helper.getCountGewAll((int)gem, guName));
                feature.put("gew_l", this.helper.getLengthGewAll((int)gem, guName));
                feature.put("offene_l", offenLength);
                feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                feature.put("prof_l", prof);
                feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                feature.put("mw_l", mw);
                feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                feature.put("profTrap_a", this.getCountProf("tr", (int)gem, guName));
                feature.put("profTrap_l", this.getLengthProf("tr", (int)gem, guName));
                feature.put("profRe_a", this.getCountProf("re", (int)gem, guName));
                feature.put("profRe_l", this.getLengthProf("re", (int)gem, guName));
                feature.put("brSohleMin", this.getMinMax("brSo", (int)gem, guName, true));
                feature.put("brSohleMit", this.getMit("brSo", (int)gem, guName));
                feature.put("brSohleMax", this.getMinMax("brSo", (int)gem, guName, false));
                feature.put("bvReMin", this.getMinMax("bvRe", (int)gem, guName, true));
                feature.put("bvReMit", this.getMit("bvRe", (int)gem, guName));
                feature.put("bvReMax", this.getMinMax("bvRe", (int)gem, guName, false));
                feature.put("bhReMin", this.getMinMax("bhRe", (int)gem, guName, true));
                feature.put("bhReMit", this.getMit("bhRe", (int)gem, guName));
                feature.put("bhReMax", this.getMinMax("bhRe", (int)gem, guName, false));
                feature.put("blReMin", this.getMinMax("blRe", (int)gem, guName, true));
                feature.put("blReMit", this.getMit("blRe", (int)gem, guName));
                feature.put("blReMax", this.getMinMax("blRe", (int)gem, guName, false));
                feature.put("bvLiMin", this.getMinMax("bvLi", (int)gem, guName, true));
                feature.put("bvLiMit", this.getMit("bvLi", (int)gem, guName));
                feature.put("bvLiMax", this.getMinMax("bvLi", (int)gem, guName, false));
                feature.put("bhLiMin", this.getMinMax("bhLi", (int)gem, guName, true));
                feature.put("bhLiMit", this.getMit("bhLi", (int)gem, guName));
                feature.put("bhLiMax", this.getMinMax("bhLi", (int)gem, guName, false));
                feature.put("blLiMin", this.getMinMax("blLi", (int)gem, guName, true));
                feature.put("blLiMit", this.getMit("blLi", (int)gem, guName));
                feature.put("blLiMax", this.getMinMax("blLi", (int)gem, guName, false));
                feature.put("flSohle", this.getSum("flSo", (int)gem, guName));
                feature.put("flBoeRe", this.getSum("flBRe", (int)gem, guName));
                feature.put("flBoeLi", this.getSum("flBLi", (int)gem, guName));
                feature.put("flBoe", this.getSum("flB", (int)gem, guName));
                feature.put("flGer", this.getSum("flGer", (int)gem, guName));
                feature.put("brGewMin", this.getMinMax("brGew", (int)gem, guName, true));
                feature.put("brGewMit", this.getMit("brGew", (int)gem, guName));
                feature.put("brGewMax", this.getMinMax("brGew", (int)gem, guName, false));
                feature.put("flGew", this.getSum("flGew", (int)gem, guName));
                feature.put("blNassReMin", this.getMinMax("blNRe", (int)gem, guName, true));
                feature.put("blNassReMit", this.getMit("blNRe", (int)gem, guName));
                feature.put("blNassReMax", this.getMinMax("blNRe", (int)gem, guName, false));
                feature.put("blTroReMin", this.getMinMax("blTRe", (int)gem, guName, true));
                feature.put("blTroReMit", this.getMit("blTRe", (int)gem, guName));
                feature.put("blTroReMax", this.getMinMax("blTRe", (int)gem, guName, false));
                feature.put("blNassLiMin", this.getMinMax("blNLi", (int)gem, guName, true));
                feature.put("blNassLiMit", this.getMit("blNLi", (int)gem, guName));
                feature.put("blNassLiMax", this.getMinMax("blNLi", (int)gem, guName, false));
                feature.put("blTroLiMin", this.getMinMax("blTLi", (int)gem, guName, true));
                feature.put("blTroLiMit", this.getMit("blTLi", (int)gem, guName));
                feature.put("blTroLiMax", this.getMinMax("blTLi", (int)gem, guName, false));
                feature.put("flQsGerMin", this.getMinMax("flQsGer", (int)gem, guName, true));
                feature.put("flQsGerMit", this.getMit("flQsGer", (int)gem, guName));
                feature.put("flQsGerMax", this.getMinMax("flQsGer", (int)gem, guName, false));
                feature.put("flQsGewMin", this.getMinMax("flQsGew", (int)gem, guName, true));
                feature.put("flQsGewMit", this.getMit("flQsGew", (int)gem, guName));
                feature.put("flQsGewMax", this.getMinMax("flQsGew", (int)gem, guName, false));
                feature.put("flBoeNassRe", this.getSum("flBnRe", (int)gem, guName));
                feature.put("flBoeTroRe", this.getSum("flBtRe", (int)gem, guName));
                feature.put("flBoeNassLi", this.getSum("flBnLi", (int)gem, guName));
                feature.put("flBoeTroLi", this.getSum("flBtLi", (int)gem, guName));
                feature.put("flBoeNass", this.getSum("flBn", (int)gem, guName));
                feature.put("flBoeTro", this.getSum("flBt", (int)gem, guName));
                feature.put("flNass", this.getSum("flN", (int)gem, guName));
                feature.put("summe", false);
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            if (this.getGu(gem) == null || this.getGu(gem).isEmpty()) continue;
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWidmung(gem, guName)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    double offenLength = this.helper.getLengthOffeneAbschn(gem, guName, wdm);
                    double prof = this.getLengthGew(gem, guName, wdm);
                    double mw = this.getLengthMw(gem, guName, wdm);
                    double gewAll = this.helper.getLengthGewAll(gem, guName, wdm);
                    feature.put("group", String.valueOf(gem));
                    feature.put("name", this.getGuId(gem, guName));
                    feature.put("gu", guName);
                    feature.put("wdm", wdm);
                    feature.put("gew_a", this.helper.getCountGewAll(gem, guName, wdm));
                    feature.put("gew_l", this.helper.getLengthGewAll(gem, guName, wdm));
                    feature.put("offene_l", offenLength);
                    feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                    feature.put("prof_l", prof);
                    feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : offenLength);
                    feature.put("mw_l", mw);
                    feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                    feature.put("profTrap_a", this.getCountProf("tr", gem, guName, wdm));
                    feature.put("profTrap_l", this.getLengthProf("tr", gem, guName, wdm));
                    feature.put("profRe_a", this.getCountProf("re", gem, guName, wdm));
                    feature.put("profRe_l", this.getLengthProf("re", gem, guName, wdm));
                    feature.put("brSohleMin", this.getMinMax("brSo", gem, guName, wdm, true));
                    feature.put("brSohleMit", this.getMit("brSo", gem, guName, wdm));
                    feature.put("brSohleMax", this.getMinMax("brSo", gem, guName, wdm, false));
                    feature.put("bvReMin", this.getMinMax("bvRe", gem, guName, wdm, true));
                    feature.put("bvReMit", this.getMit("bvRe", gem, guName, wdm));
                    feature.put("bvReMax", this.getMinMax("bvRe", gem, guName, wdm, false));
                    feature.put("bhReMin", this.getMinMax("bhRe", gem, guName, wdm, true));
                    feature.put("bhReMit", this.getMit("bhRe", gem, guName, wdm));
                    feature.put("bhReMax", this.getMinMax("bhRe", gem, guName, wdm, false));
                    feature.put("blReMin", this.getMinMax("blRe", gem, guName, wdm, true));
                    feature.put("blReMit", this.getMit("blRe", gem, guName, wdm));
                    feature.put("blReMax", this.getMinMax("blRe", gem, guName, wdm, false));
                    feature.put("bvLiMin", this.getMinMax("bvLi", gem, guName, wdm, true));
                    feature.put("bvLiMit", this.getMit("bvLi", gem, guName, wdm));
                    feature.put("bvLiMax", this.getMinMax("bvLi", gem, guName, wdm, false));
                    feature.put("bhLiMin", this.getMinMax("bhLi", gem, guName, wdm, true));
                    feature.put("bhLiMit", this.getMit("bhLi", gem, guName, wdm));
                    feature.put("bhLiMax", this.getMinMax("bhLi", gem, guName, wdm, false));
                    feature.put("blLiMin", this.getMinMax("blLi", gem, guName, wdm, true));
                    feature.put("blLiMit", this.getMit("blLi", gem, guName, wdm));
                    feature.put("blLiMax", this.getMinMax("blLi", gem, guName, wdm, false));
                    feature.put("flSohle", this.getSum("flSo", gem, guName, wdm));
                    feature.put("flBoeRe", this.getSum("flBRe", gem, guName, wdm));
                    feature.put("flBoeLi", this.getSum("flBLi", gem, guName, wdm));
                    feature.put("flBoe", this.getSum("flB", gem, guName, wdm));
                    feature.put("flGer", this.getSum("flGer", gem, guName, wdm));
                    feature.put("brGewMin", this.getMinMax("brGew", gem, guName, wdm, true));
                    feature.put("brGewMit", this.getMit("brGew", gem, guName, wdm));
                    feature.put("brGewMax", this.getMinMax("brGew", gem, guName, wdm, false));
                    feature.put("flGew", this.getSum("flGew", gem, guName, wdm));
                    feature.put("blNassReMin", this.getMinMax("blNRe", gem, guName, wdm, true));
                    feature.put("blNassReMit", this.getMit("blNRe", gem, guName, wdm));
                    feature.put("blNassReMax", this.getMinMax("blNRe", gem, guName, wdm, false));
                    feature.put("blTroReMin", this.getMinMax("blTRe", gem, guName, wdm, true));
                    feature.put("blTroReMit", this.getMit("blTRe", gem, guName, wdm));
                    feature.put("blTroReMax", this.getMinMax("blTRe", gem, guName, wdm, false));
                    feature.put("blNassLiMin", this.getMinMax("blNLi", gem, guName, wdm, true));
                    feature.put("blNassLiMit", this.getMit("blNLi", gem, guName, wdm));
                    feature.put("blNassLiMax", this.getMinMax("blNLi", gem, guName, wdm, false));
                    feature.put("blTroLiMin", this.getMinMax("blTLi", gem, guName, wdm, true));
                    feature.put("blTroLiMit", this.getMit("blTLi", gem, guName, wdm));
                    feature.put("blTroLiMax", this.getMinMax("blTLi", gem, guName, wdm, false));
                    feature.put("flQsGerMin", this.getMinMax("flQsGer", gem, guName, wdm, true));
                    feature.put("flQsGerMit", this.getMit("flQsGer", gem, guName, wdm));
                    feature.put("flQsGerMax", this.getMinMax("flQsGer", gem, guName, wdm, false));
                    feature.put("flQsGewMin", this.getMinMax("flQsGew", gem, guName, wdm, true));
                    feature.put("flQsGewMit", this.getMit("flQsGew", gem, guName, wdm));
                    feature.put("flQsGewMax", this.getMinMax("flQsGew", gem, guName, wdm, false));
                    feature.put("flBoeNassRe", this.getSum("flBnRe", gem, guName, wdm));
                    feature.put("flBoeTroRe", this.getSum("flBtRe", gem, guName, wdm));
                    feature.put("flBoeNassLi", this.getSum("flBnLi", gem, guName, wdm));
                    feature.put("flBoeTroLi", this.getSum("flBtLi", gem, guName, wdm));
                    feature.put("flBoeNass", this.getSum("flBn", gem, guName, wdm));
                    feature.put("flBoeTro", this.getSum("flBt", gem, guName, wdm));
                    feature.put("flNass", this.getSum("flN", gem, guName, wdm));
                    feature.put("summe", false);
                    features.add(feature);
                    featureListKum.add(feature);
                    featureListGuKum.add(feature);
                }
                features.add(this.createKumFeature(featureListGuKum, true));
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        return this.createKumFeature(featureListKum, subtotal, 0);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, int stat) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : new ArrayList<String>(firstElement.keySet())) {
            double totalTmp;
            double specificTmp;
            Object value = firstElement.get(key);
            if (key.endsWith("offene_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("offene_l");
                    totalTmp = (Double)f.get("gew_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("prof_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("prof_l");
                    totalTmp = (Double)f.get("offene_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("group")) {
                kumFeature.put(key, value);
                continue;
            }
            if (key.endsWith("mw_a") && value instanceof Double) {
                double lengthTotal = 0.0;
                double lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = (Double)f.get("mw_l");
                    totalTmp = (Double)f.get("prof_l");
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("Min") && value instanceof Double) {
                double min = (Double)value;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val < min)) continue;
                    min = val;
                }
                kumFeature.put(key, min);
                continue;
            }
            if (key.endsWith("Max") && value instanceof Double) {
                double max = (Double)value;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                kumFeature.put(key, max);
                continue;
            }
            if (key.endsWith("Mit") && value instanceof Double) {
                double mit = (Double)value;
                double length = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    double val = (Double)f.get(key);
                    double len = (Double)f.get("prof_l");
                    mit += val * len;
                    length += len;
                }
                kumFeature.put(key, mit / length);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (value instanceof String || value instanceof Boolean || Arrays.binarySearch(exceptionalNumberFields, key) >= 0) continue;
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private Collection<Integer> getGew(int gemNr) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjOffen tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu(int gemNr) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObjOffen tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private String getGuId(int gemNr, String owner) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private Collection<Integer> getWidmung(int gemNr, String guName) {
        List<GmdPartObjOffen> gmdList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjOffen gmdPart : gmdList) {
            if (!gmdPart.getOwner().equals(guName)) continue;
            ts.add(gmdPart.getWdm());
        }
        return ts.descendingSet();
    }

    private String getBaCd(int gemNr, int gew) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(int gemNr, int gew) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private double getLengthGew(int gemNr) {
        return this.getLengthGew(gemNr, -1);
    }

    private double getLengthGew(int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gemNr) {
        return this.getLengthMw(gemNr, -1);
    }

    private double getLengthMw(int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gemNr) {
        return this.getLengthProf(prof, gemNr, -1);
    }

    private double getLengthProf(String prof, int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getMinMax(String field, int gemNr, boolean min) {
        return this.getMinMax(field, gemNr, -1, min);
    }

    private double getMinMax(String field, int gemNr, int gewId, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, int gemNr, String gu, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, int gemNr, String gu, int wdm, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, int gemNr, int gewId, double from, double till, boolean min) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        boolean firstValue = true;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMit(String field, int gemNr) {
        return this.getMit(field, gemNr, -1);
    }

    private double getMit(String field, int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLengthInGewPart(gewId, from, till);
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getSum(String field, int gemNr) {
        return this.getSum(field, gemNr, -1);
    }

    private double getSum(String field, int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double currentVal = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    public int getCountProf(String prof, int gemNr) {
        return this.getCountProf(prof, gemNr, -1);
    }

    public int getCountProf(String prof, int gemNr, int gewId) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, int gemNr, int gewId, double from, double till) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObjOffen tmp : gemList) {
            if (tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof) || !tmp.isInGewPart(gewId, from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(int gemNr, String gu) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(int gemNr, String gu, int wdm) {
        List<GmdPartObjOffen> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObjOffen tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWdm() != wdm) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

