/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import de.cismet.cids.custom.watergis.server.search.SchuUeberReport;
import de.cismet.cids.custom.watergis.server.search.SchuWasserReport;
import de.cismet.cids.custom.watergis.server.search.VerknReport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultXStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.GewaesserReportDialog;
import de.cismet.watergis.gui.panels.GafProf;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.log4j.Logger;

public class GewaesserReport {
    private static final Logger LOG = Logger.getLogger(GewaesserReport.class);
    private static final MetaClass FG_BA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
    private static final MetaClass FG_LA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_la");
    private static final MetaClass FG_BAK_GBK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gbk");
    private static final MetaClass K_GWK_LAWA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_gwk_lawa");
    private static final MetaClass FG_BA_STAT = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_stat");
    private static final MetaClass WR_WBU_BEN = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.wr_wbu_ben");
    private static final MetaClass WR_WBU_AUS = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.wr_wbu_aus");
    private static final MetaClass MN_OW_PEGEL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.mn_ow_pegel");
    private static final MetaClass FG_BA_GMD = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gmd");
    private static final MetaClass FG_BA_GB = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gb");
    private static final MetaClass FG_BA_SB = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sb");
    private static final MetaClass FG_BA_UBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ubef");
    private static final MetaClass FG_BA_BBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_bbef");
    private static final MetaClass FG_BA_SBEF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sbef");
    private static final MetaClass FG_BA_PROF = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_prof");
    private static final MetaClass FG_BA_RL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_rl");
    private static final MetaClass FG_BA_D = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_d");
    private static final MetaClass FG_BA_DUE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_due");
    private static final MetaClass FG_BA_SCHA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_scha");
    private static final MetaClass FG_BA_WEHR = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_wehr");
    private static final MetaClass FG_BA_SCHW = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_schw");
    private static final MetaClass FG_BA_ANLP = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_anlp");
    private static final MetaClass FG_BA_ANLL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_anll");
    private static final MetaClass FG_BA_KR = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_kr");
    private static final MetaClass FG_BA_EA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ea");
    private static final MetaClass FG_BAK_GN1 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn1");
    private static final MetaClass FG_BAK_GN2 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn2");
    private static final MetaClass FG_BAK_GN3 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn3");
    private static final MetaClass FG_BA_UGHZ = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ughz");
    private static final MetaClass FG_BA_LEIS = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_leis");
    private static final MetaClass FG_BA_TECH = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_tech");
    private static final MetaClass FG_BA_DOK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_doku");
    private static final MetaClass FG_BA_PROJ = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_proj");
    private static final MetaClass FG_BA_DEICH = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.deich_ft");
    private static final MetaClass FOTO = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.foto");
    private static final MetaClass K_GU = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_gu");
    private static ImageIcon annotationIco = new ImageIcon(GewaesserReport.class.getResource("/de/cismet/watergis/reports/Station.png"));
    private static final DecimalFormat formatter = new DecimalFormat();
    private static final Map<String, CidsLayer> layerMap;

    public File createReport(String baCd) throws Exception {
        boolean isGu = AppBroker.getInstance().isAdminUser() || AppBroker.getInstance().isGu();
        boolean isWawi = AppBroker.getInstance().isWawiOrAdminUser();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, JRDataSource> dataSources = new HashMap<String, JRDataSource>();
        parameters.put("ba_cd", baCd);
        parameters.put("dataSources", dataSources);
        parameters.put("wbblPath", "http://fry.fis-wasser-mv.de/watergis/wr_wbu_wbbl_o/");
        parameters.put("karte", GewaesserReportDialog.getInstance().isKarte());
        parameters.put("isGu", isGu);
        parameters.put("isWawi", isWawi);
        CidsLayer cl = this.createCidsLayer(FG_BA);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
        CidsLayerFeature baFeature = null;
        if (featureList != null && featureList.size() == 1) {
            baFeature = (CidsLayerFeature)featureList.get(0);
        }
        if (GewaesserReportDialog.getInstance().isGwk()) {
            dataSources.put("gwk", this.getLawaGwk(baCd, baFeature));
            parameters.put("gwk", true);
        }
        if (GewaesserReportDialog.getInstance().isGbk()) {
            dataSources.put("gbk", this.getLawaGbk(baCd, baFeature));
            parameters.put("gbk", true);
        }
        if (GewaesserReportDialog.getInstance().isBen()) {
            dataSources.put("wr_ben", this.getWasserrechtBenutzung(baCd));
            parameters.put("ben", true);
        }
        if (GewaesserReportDialog.getInstance().isAus()) {
            dataSources.put("wr_aus", this.getWasserrechtAusbau(baCd));
            parameters.put("ausbau", true);
        }
        if (GewaesserReportDialog.getInstance().isPegel()) {
            dataSources.put("pegel", this.getPegel(baCd));
            parameters.put("pegel", true);
        }
        if (GewaesserReportDialog.getInstance().isGb()) {
            dataSources.put("gb", this.getGb(baCd));
            parameters.put("gb", true);
        }
        if (GewaesserReportDialog.getInstance().isGmd()) {
            dataSources.put("gmd", this.getGmd(baCd));
            parameters.put("gem", true);
        }
        if (GewaesserReportDialog.getInstance().isSb()) {
            dataSources.put("sb", this.getSb(baCd));
            parameters.put("sb", true);
        }
        if (GewaesserReportDialog.getInstance().isProf()) {
            dataSources.put("prof", this.getProfile(baCd));
            parameters.put("prof", true);
        }
        if (GewaesserReportDialog.getInstance().isSbef()) {
            dataSources.put("sbef", this.getSbef(baCd));
            parameters.put("sbef", true);
        }
        if (GewaesserReportDialog.getInstance().isBbef()) {
            dataSources.put("bbef", this.getBbef(baCd));
            parameters.put("bbef", true);
        }
        if (GewaesserReportDialog.getInstance().isUbef()) {
            dataSources.put("ubef", this.getUbef(baCd));
            parameters.put("ubef", true);
        }
        if (GewaesserReportDialog.getInstance().isRl()) {
            dataSources.put("rl", this.getRl(baCd));
            parameters.put("rl", true);
        }
        if (GewaesserReportDialog.getInstance().isD()) {
            dataSources.put("d", this.getD(baCd));
            parameters.put("d", true);
        }
        if (GewaesserReportDialog.getInstance().isDue()) {
            dataSources.put("due", this.getDue(baCd));
            parameters.put("due", true);
        }
        if (GewaesserReportDialog.getInstance().isScha()) {
            dataSources.put("scha", this.getScha(baCd));
            parameters.put("scha", true);
        }
        if (GewaesserReportDialog.getInstance().isWehr()) {
            dataSources.put("wehr", this.getWehr(baCd));
            parameters.put("wehr", true);
        }
        if (GewaesserReportDialog.getInstance().isSchw()) {
            dataSources.put("schw", this.getSchw(baCd));
            parameters.put("schoepf", true);
        }
        if (GewaesserReportDialog.getInstance().isAnlp()) {
            dataSources.put("anlp", this.getAnlp(baCd));
            parameters.put("anlp", true);
        }
        if (GewaesserReportDialog.getInstance().isAnll()) {
            dataSources.put("anll", this.getAnll(baCd));
            parameters.put("anll", true);
        }
        if (GewaesserReportDialog.getInstance().isKr()) {
            dataSources.put("kr", this.getKr(baCd));
            parameters.put("kr", true);
        }
        if (GewaesserReportDialog.getInstance().isEa()) {
            dataSources.put("ea", this.getEa(baCd));
            parameters.put("ea", true);
        }
        if (GewaesserReportDialog.getInstance().isVerkn()) {
            dataSources.put("verkn", this.getVerkn(baCd));
            parameters.put("verk", true);
        }
        if (GewaesserReportDialog.getInstance().isTopo()) {
            dataSources.put("topo", this.getTopo(baCd, baFeature));
            parameters.put("topo", true);
        }
        if (GewaesserReportDialog.getInstance().isWsg()) {
            dataSources.put("schutz", this.getSchutz(baCd));
            parameters.put("wsg", true);
        }
        if (GewaesserReportDialog.getInstance().isSchutzgebiete()) {
            dataSources.put("schutzUeber", this.getUeber(baCd));
            parameters.put("ueber", true);
        }
        if (GewaesserReportDialog.getInstance().isDeich()) {
            dataSources.put("deich", this.getDeich(baCd));
            parameters.put("deich", true);
        }
        if (GewaesserReportDialog.getInstance().isUghz()) {
            dataSources.put("ughz", this.getUghz(baCd));
            parameters.put("ughz", true);
        }
        if (GewaesserReportDialog.getInstance().isFoto()) {
            dataSources.put("foto", this.getFoto(baCd));
            parameters.put("foto", true);
        }
        if (GewaesserReportDialog.getInstance().isLeis()) {
            dataSources.put("leis", this.getLeis(baCd));
            parameters.put("leis", true);
        }
        if (GewaesserReportDialog.getInstance().isTech()) {
            dataSources.put("tech", this.getTech(baCd));
            parameters.put("tech", true);
        }
        if (GewaesserReportDialog.getInstance().isDoku()) {
            dataSources.put("dok", this.getDok(baCd));
            parameters.put("dok", true);
        }
        if (GewaesserReportDialog.getInstance().isProj()) {
            dataSources.put("proj", this.getProj(baCd));
            parameters.put("proj", true);
        }
        if (featureList != null && featureList.size() == 1) {
            CidsLayerFeature feature = (CidsLayerFeature)featureList.get(0);
            if (!GewaesserReportDialog.getInstance().isKarte()) {
                parameters.put("map", null);
            } else {
                parameters.put("map", this.generateMap(feature));
            }
            parameters.put("quelle", this.convertStation(feature.getGeometry().getLength()));
            parameters.put("muendung", this.convertStation(0.0));
            parameters.put("senke", 0);
            dataSources.put("dummy", this.getSteckbrief(feature));
            JRDataSource dataSource = this.getSteckbrief(feature);
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GewaesserReport.class.getResourceAsStream("/de/cismet/watergis/reports/gewaesser.jasper"));
            dataSources.put("steckbrief", dataSource);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)new FeatureDataSource((FeatureDataSource)dataSource));
            jasperPrint.setOrientation(jasperReport.getOrientationValue());
            File file = new File(GewaesserReportDialog.getInstance().getPath() + File.separator + GafProf.removeIllegaleFileNameCharacters((String)feature.getProperty("ba_cd")) + ".pdf");
            FileOutputStream fout = new FileOutputStream(file);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)out);
            out.close();
            return file;
        }
        return null;
    }

    public void createReport(String baCd, String path) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, JRDataSource> dataSources = new HashMap<String, JRDataSource>();
        parameters.put("ba_cd", baCd);
        parameters.put("dataSources", dataSources);
        parameters.put("wbblPath", "http://fry.fis-wasser-mv.de/watergis/wr_wbu_wbbl_o/");
        parameters.put("karte", true);
        CidsLayer cl = this.createCidsLayer(FG_BA);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
        CidsLayerFeature baFeature = null;
        if (featureList != null && featureList.size() == 1) {
            baFeature = (CidsLayerFeature)featureList.get(0);
        }
        dataSources.put("gwk", this.getLawaGwk(baCd, baFeature));
        parameters.put("gwk", true);
        dataSources.put("gbk", this.getLawaGbk(baCd, baFeature));
        parameters.put("gbk", true);
        dataSources.put("wr_ben", this.getWasserrechtBenutzung(baCd));
        parameters.put("ben", true);
        dataSources.put("wr_aus", this.getWasserrechtAusbau(baCd));
        parameters.put("ausbau", true);
        dataSources.put("pegel", this.getPegel(baCd));
        parameters.put("pegel", true);
        dataSources.put("gb", this.getGb(baCd));
        parameters.put("gb", true);
        dataSources.put("gmd", this.getGmd(baCd));
        parameters.put("gem", true);
        dataSources.put("sb", this.getSb(baCd));
        parameters.put("sb", true);
        dataSources.put("prof", this.getProfile(baCd));
        parameters.put("prof", true);
        dataSources.put("sbef", this.getSbef(baCd));
        parameters.put("sbef", true);
        dataSources.put("bbef", this.getBbef(baCd));
        parameters.put("bbef", true);
        dataSources.put("ubef", this.getUbef(baCd));
        parameters.put("ubef", true);
        dataSources.put("rl", this.getRl(baCd));
        parameters.put("rl", true);
        dataSources.put("d", this.getD(baCd));
        parameters.put("d", true);
        dataSources.put("due", this.getDue(baCd));
        parameters.put("due", true);
        dataSources.put("scha", this.getScha(baCd));
        parameters.put("scha", true);
        dataSources.put("wehr", this.getWehr(baCd));
        parameters.put("wehr", true);
        dataSources.put("schw", this.getSchw(baCd));
        parameters.put("schoepf", true);
        dataSources.put("anlp", this.getAnlp(baCd));
        parameters.put("anlp", true);
        dataSources.put("anll", this.getAnll(baCd));
        parameters.put("anll", true);
        dataSources.put("kr", this.getKr(baCd));
        parameters.put("kr", true);
        dataSources.put("ea", this.getEa(baCd));
        parameters.put("ea", true);
        dataSources.put("verkn", this.getVerkn(baCd));
        parameters.put("verk", true);
        dataSources.put("topo", this.getTopo(baCd, baFeature));
        parameters.put("topo", true);
        dataSources.put("schutz", this.getSchutz(baCd));
        parameters.put("wsg", true);
        dataSources.put("schutzUeber", this.getUeber(baCd));
        parameters.put("ueber", true);
        dataSources.put("deich", this.getDeich(baCd));
        parameters.put("deich", true);
        dataSources.put("ughz", this.getUghz(baCd));
        parameters.put("ughz", true);
        dataSources.put("foto", this.getFoto(baCd));
        parameters.put("foto", true);
        dataSources.put("leis", this.getLeis(baCd));
        parameters.put("leis", true);
        dataSources.put("tech", this.getTech(baCd));
        parameters.put("tech", true);
        dataSources.put("dok", this.getDok(baCd));
        parameters.put("dok", true);
        dataSources.put("proj", this.getProj(baCd));
        parameters.put("proj", true);
        if (featureList != null && featureList.size() == 1) {
            CidsLayerFeature feature = (CidsLayerFeature)featureList.get(0);
            parameters.put("map", this.generateMap(feature));
            parameters.put("quelle", feature.getGeometry().getLength());
            parameters.put("senke", 0);
            dataSources.put("dummy", this.getSteckbrief(feature));
            JRDataSource dataSource = this.getSteckbrief(feature);
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GewaesserReport.class.getResourceAsStream("/de/cismet/watergis/reports/gewaesser.jasper"));
            dataSources.put("steckbrief", dataSource);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)new FeatureDataSource((FeatureDataSource)dataSource));
            jasperPrint.setOrientation(jasperReport.getOrientationValue());
            FileOutputStream fout = new FileOutputStream(new File(path + File.separator + GafProf.removeIllegaleFileNameCharacters((String)feature.getProperty("ba_cd")) + ".pdf"));
            BufferedOutputStream out = new BufferedOutputStream(fout);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)out);
            out.close();
        }
    }

    private Image generateMap(CidsLayerFeature feature) {
        try {
            String urlBackground = "https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web_light_grau&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage";
            XBoundingBox boundingBox = new XBoundingBox(feature.getGeometry());
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            HeadlessMapProvider mapProvider = new HeadlessMapProvider();
            mapProvider.setCenterMapOnResize(true);
            mapProvider.setBoundingBox(boundingBox);
            SimpleWmsGetMapUrl getMapUrl = new SimpleWmsGetMapUrl("https://sgx.geodatenzentrum.de/wms_topplus_open?REQUEST=GetMap&VERSION=1.1.1&SERVICE=WMS&LAYERS=web_light_grau&BBOX=<cismap:boundingBox>&SRS=EPSG:5650&FORMAT=image/png&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage");
            SimpleWMS simpleWms = new SimpleWMS(getMapUrl);
            mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
            mapProvider.getImageAndWait(72, 130, 762.0, 400.0);
            double scale = mapProvider.getMappingComponent().getScaleDenominator();
            CidsLayer cl = this.createCidsLayer(FG_BA);
            List featureList = cl.getFeatureFactory().createFeatures(null, mapProvider.getCurrentBoundingBoxFromMap(), null, 0, 0, null);
            CidsLayer clStat = this.createCidsLayer(FG_BA_STAT);
            String query = "ba_cd = '" + feature.getProperty("ba_cd") + "'";
            List statList = clStat.getFeatureFactory().createFeatures((Object)query, mapProvider.getCurrentBoundingBoxFromMap(), null, 0, 0, null);
            for (CidsLayerFeature fgBa : featureList) {
                if (fgBa.getId() == feature.getId()) {
                    fgBa.setLinePaint((Paint)Color.RED);
                    fgBa.setLineWidth(3);
                } else {
                    fgBa.setLinePaint((Paint)Color.BLUE);
                    fgBa.setLineWidth(2);
                }
                mapProvider.addFeature((Feature)fgBa);
            }
            for (CidsLayerFeature stat : statList) {
                int statValue = (int)((Double)stat.getProperty("ba_st_km") * 1000.0);
                if (scale > 25000.0 && scale <= 100000.0 && statValue % 500 != 0 || scale > 100000.0 && statValue % 1000 != 0) continue;
                DefaultXStyledFeature feat = new DefaultXStyledFeature(null, "", "", null, null);
                feat.setGeometry(stat.getGeometry());
                feat.setPointAnnotationSymbol(FeatureAnnotationSymbol.newCenteredFeatureAnnotationSymbol((Image)annotationIco.getImage(), (Image)annotationIco.getImage()));
                feat.setPrimaryAnnotation(stat.getProperty("ba_st_c").toString());
                feat.setPrimaryAnnotationVisible(true);
                feat.setPrimaryAnnotationPaint((Paint)Color.BLACK);
                feat.setPrimaryAnnotationJustification(0.5f);
                feat.setPrimaryAnnotationFont(new Font("sansserif", 0, 10));
                feat.setAutoScale(true);
                mapProvider.addFeature((Feature)feat);
            }
            return mapProvider.getImageAndWait(72, 200, 760.0, 398.0);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrievin gmap.", (Throwable)e);
            return null;
        }
    }

    private Double calculateFromRelatedToFeatureGeom(Geometry geom, CidsLayerFeature feature) {
        return this.calculateRelatedToFeatureGeom(geom, feature, false);
    }

    private Double calculateTillRelatedToFeatureGeom(Geometry geom, CidsLayerFeature feature) {
        return this.calculateRelatedToFeatureGeom(geom, feature, true);
    }

    private Double calculateRelatedToFeatureGeom(Geometry geom, CidsLayerFeature feature, boolean till) {
        LinearLocation pointLL;
        Geometry baGeom = feature.getGeometry();
        GeometryFactory f = baGeom.getFactory();
        Geometry intersection = geom.buffer(0.05, 0, 2).intersection(baGeom);
        if (intersection.isEmpty()) {
            return null;
        }
        Coordinate lastCoord = intersection.getCoordinates()[intersection.getCoordinates().length - 1];
        Point lastPoint = f.createPoint(lastCoord);
        Coordinate firstCoord = intersection.getCoordinates()[0];
        Point firstPoint = f.createPoint(firstCoord);
        double lastPointPosition = 0.0;
        double firstPointPosition = 0.0;
        LocationIndexedLine lineLIL = new LocationIndexedLine(baGeom);
        LengthLocationMap lineLLM = new LengthLocationMap(baGeom);
        if (lastPoint.distance(baGeom) < 0.01) {
            pointLL = lineLIL.indexOf(lastCoord);
            lastPointPosition = lineLLM.getLength(pointLL);
        }
        if (firstPoint.distance(baGeom) < 0.01) {
            pointLL = lineLIL.indexOf(firstCoord);
            firstPointPosition = lineLLM.getLength(pointLL);
        }
        if (till) {
            return lastPointPosition > firstPointPosition ? lastPointPosition : firstPointPosition;
        }
        return lastPointPosition < firstPointPosition ? lastPointPosition : firstPointPosition;
    }

    private JRDataSource getLawaGwk(String baCd, CidsLayerFeature baFeature) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_LA);
        String query = "dlm25wPk_gwk_lawa1.la_cd in (\nselect distinct k.la_cd\nfrom dlm25w.k_gwk_lawa k \njoin dlm25w.fg_bak_gwk bg on (k.id = bg.la_cd) \njoin dlm25w.fg_bak_linie l on (bg.bak_st = l.id) \njoin dlm25w.fg_bak_punkt von on l.von = von.id \njoin dlm25w.fg_bak bak on (bak.id = von.route)\nwhere \nbak.ba_cd = '" + baCd + "'\n)";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("la_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            if (baFeature == null) break;
            Double from = this.calculateFromRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
            Double till = this.calculateTillRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
            if (from == null || till == null) continue;
            feature.put("von", this.convertStation(from));
            feature.put("bis", this.convertStation(till));
            feature.put("laenge", this.toString(Math.abs(till - from)));
            feature.put("gwk", this.toString(cidsFeature.getProperty("la_cd")));
            feature.put("gwk_kurz", this.toString(cidsFeature.getProperty("la_cd_k")));
            feature.put("name", this.toString(cidsFeature.getProperty("la_gn")));
            feature.put("wrrl", this.toX(cidsFeature.getProperty("la_wrrl")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getSteckbrief(CidsLayerFeature f) throws Exception {
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        String unterhalter = "";
        if (f.getBean().getProperty("ww_gr.praefixgroup") != null) {
            CidsLayer cl = this.createCidsLayer(K_GU);
            String query = "code = '" + f.getBean().getProperty("ww_gr.praefixgroup") + "'";
            List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
            if (featureList != null && featureList.size() == 1 && (unterhalter = (String)((CidsLayerFeature)featureList.get(0)).getProperty("name")) != null) {
                unterhalter = unterhalter.replace("Wasser- und Schifffahrtsamt", "WSA");
                unterhalter = unterhalter.replace("Staatliches Amt f\u00fcr Landwirtschaft und Umwelt", "StALU");
                unterhalter = unterhalter.replace("Landesamt f\u00fcr Umwelt, Naturschutz und Geologie Mecklenburg-Vorpommern", "LUNG");
            }
        }
        HashMap<String, String> feature = new HashMap<String, String>();
        feature.put("gewaessercode", this.toString(f.getProperty("ba_cd")));
        feature.put("unterhalter", unterhalter);
        feature.put("gewaessername", this.toString(f.getProperty("ba_gn")));
        feature.put("laenge", this.toString(f.getProperty("laenge")));
        feature.put("ordnung", f.getProperty("wdm") != null ? String.valueOf(f.getProperty("wdm")) : null);
        feature.put("datum", this.toString(new Date()));
        features.add(feature);
        return new FeatureDataSource(features);
    }

    private JRDataSource getLawaGbk(String baCd, CidsLayerFeature baFeature) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BAK_GBK);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("bak_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            CidsBean bean = (CidsBean)cidsFeature.getBean().getProperty("gbk_lawa");
            HashMap<String, String> feature = new HashMap<String, String>();
            Double from = this.calculateFromRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
            Double till = this.calculateTillRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
            if (from == null || till == null) continue;
            String gwkLawa = this.toString(bean.getProperty("gwk_lawa"));
            CidsLayer gwkLayer = this.createCidsLayer(K_GWK_LAWA);
            String gwkQuery = gwkLayer.decoratePropertyName("la_cd") + " = " + gwkLawa;
            List gwkList = gwkLayer.getFeatureFactory().createFeatures((Object)gwkQuery, null, null, 0, 0, null);
            if (gwkList != null && gwkList.size() == 1) {
                feature.put("name", this.toString(((CidsLayerFeature)gwkList.get(0)).getProperty("la_gn")));
            }
            feature.put("von", this.convertStation(from));
            feature.put("bis", this.convertStation(till));
            feature.put("laenge", this.toString(Math.abs(till - from)));
            feature.put("gbk", this.toString(bean.getProperty("gbk_lawa")));
            feature.put("gbk_kurz", this.toString(bean.getProperty("gbk_lawa_k")));
            feature.put("gbk_von", this.toString(bean.getProperty("gbk_von")));
            feature.put("gbk_bis", this.toString(bean.getProperty("gbk_bis")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getSchutz(String baCd) throws Exception {
        ArrayList propList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new SchuWasserReport(baCd));
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (ArrayList featurePops : propList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            Double laenge = Math.abs((Double)featurePops.get(0) - (Double)featurePops.get(1));
            feature.put("von", this.convertStation((Double)featurePops.get(0)));
            feature.put("bis", this.convertStation((Double)featurePops.get(1)));
            feature.put("zone", this.toString(featurePops.get(3)));
            feature.put("wbbl", this.toString(featurePops.get(4)));
            feature.put("name", this.toString(featurePops.get(2)));
            feature.put("text", this.toString(featurePops.get(5)));
            feature.put("laenge", this.toString(laenge));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getUeber(String baCd) throws Exception {
        ArrayList propList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new SchuUeberReport(baCd));
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (ArrayList featurePops : propList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            Double laenge = Math.abs((Double)featurePops.get(0) - (Double)featurePops.get(1));
            feature.put("von", this.convertStation((Double)featurePops.get(0)));
            feature.put("bis", this.convertStation((Double)featurePops.get(1)));
            feature.put("wbbl", this.toString(featurePops.get(3)));
            feature.put("name", this.toString(featurePops.get(2)));
            feature.put("text", this.toString(featurePops.get(4)));
            feature.put("laenge", this.toString(laenge));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getVerkn(String baCd) throws Exception {
        ArrayList propList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new VerknReport(baCd));
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        if (propList != null) {
            for (ArrayList featurePops : propList) {
                if (((Boolean)featurePops.get(4)).booleanValue()) continue;
                HashMap<String, String> feature = new HashMap<String, String>();
                feature.put("station", this.convertStation((Double)featurePops.get(0)));
                feature.put("einm", this.toString(featurePops.get(1)));
                feature.put("entsp", this.toString(featurePops.get(2)));
                feature.put("seite", featurePops.get(1) != null && !featurePops.get(1).equals(" ") ? this.flipSide(this.toString(featurePops.get(3))) : this.toString(featurePops.get(3)));
                features.add(feature);
            }
        }
        return new FeatureDataSource(features);
    }

    private String flipSide(String side) {
        if (side != null && side.equals("re")) {
            return "li";
        }
        if (side != null && side.equals("li")) {
            return "re";
        }
        return side;
    }

    private JRDataSource getTopo(String baCd, CidsLayerFeature baFeature) throws Exception {
        Double till;
        Double from;
        CidsLayerFeature cidsFeature;
        Iterator featureIt;
        CidsLayer gn1 = this.createCidsLayer(FG_BAK_GN1);
        String queryGn1 = gn1.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsaGn1 = (FeatureServiceAttribute)gn1.getFeatureServiceAttributes().get("bak_st_von");
        fsaGn1.setAscOrder(true);
        List featureListGn1 = gn1.getFeatureFactory().createFeatures((Object)queryGn1, null, null, 0, 0, new FeatureServiceAttribute[]{fsaGn1});
        CidsLayer gn2 = this.createCidsLayer(FG_BAK_GN2);
        String queryGn2 = gn2.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsaGn2 = (FeatureServiceAttribute)gn2.getFeatureServiceAttributes().get("bak_st_von");
        fsaGn2.setAscOrder(true);
        List featureListGn2 = gn2.getFeatureFactory().createFeatures((Object)queryGn2, null, null, 0, 0, new FeatureServiceAttribute[]{fsaGn2});
        CidsLayer gn3 = this.createCidsLayer(FG_BAK_GN3);
        String queryGn3 = gn3.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsaGn3 = (FeatureServiceAttribute)gn3.getFeatureServiceAttributes().get("bak_st_von");
        fsaGn3.setAscOrder(true);
        List featureListGn3 = gn3.getFeatureFactory().createFeatures((Object)queryGn3, null, null, 0, 0, new FeatureServiceAttribute[]{fsaGn3});
        if (featureListGn1 != null) {
            featureIt = featureListGn1.iterator();
            while (featureIt.hasNext()) {
                cidsFeature = (CidsLayerFeature)featureIt.next();
                from = this.calculateFromRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                till = this.calculateTillRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                if (from == null || till == null) {
                    featureIt.remove();
                }
                cidsFeature.setProperty("bak_st_von", (Object)from);
                cidsFeature.setProperty("bak_st_bis", (Object)till);
                cidsFeature.setProperty("laenge", (Object)this.toString(Math.abs(till - from)));
            }
        }
        if (featureListGn2 != null) {
            featureIt = featureListGn2.iterator();
            while (featureIt.hasNext()) {
                cidsFeature = (CidsLayerFeature)featureIt.next();
                from = this.calculateFromRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                till = this.calculateTillRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                if (from == null || till == null) {
                    featureIt.remove();
                }
                cidsFeature.setProperty("bak_st_von", (Object)from);
                cidsFeature.setProperty("bak_st_bis", (Object)till);
                cidsFeature.setProperty("laenge", (Object)this.toString(Math.abs(till - from)));
            }
        }
        if (featureListGn3 != null) {
            featureIt = featureListGn3.iterator();
            while (featureIt.hasNext()) {
                cidsFeature = (CidsLayerFeature)featureIt.next();
                from = this.calculateFromRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                till = this.calculateTillRelatedToFeatureGeom(cidsFeature.getGeometry(), baFeature);
                if (from == null || till == null) {
                    featureIt.remove();
                }
                cidsFeature.setProperty("bak_st_von", (Object)from);
                cidsFeature.setProperty("bak_st_bis", (Object)till);
                cidsFeature.setProperty("laenge", (Object)this.toString(Math.abs(till - from)));
            }
        }
        topoFeatureCalc calc = new topoFeatureCalc();
        calc.addFeatures(featureListGn1, "gn1", "topGn1");
        calc.addFeatures(featureListGn2, "gn2", "topGn2");
        calc.addFeatures(featureListGn3, "gn3", "topGn3");
        return new FeatureDataSource(calc.calcResult());
    }

    private JRDataSource getGmd(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_GMD);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("nummer_re", this.toString(cidsFeature.getProperty("nr_re"), false));
            feature.put("nummer_li", this.toString(cidsFeature.getProperty("nr_li"), false));
            feature.put("name_re", this.toString(cidsFeature.getProperty("name_re")));
            feature.put("name_li", this.toString(cidsFeature.getProperty("name_li")));
            feature.put("reli", this.toString(cidsFeature.getProperty("st_rl").equals("2")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getGb(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_GB);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("nummer_re", this.toString(cidsFeature.getProperty("nr_re"), false));
            feature.put("nummer_li", this.toString(cidsFeature.getProperty("nr_li"), false));
            feature.put("name_re", this.toString(cidsFeature.getProperty("name_re")));
            feature.put("name_li", this.toString(cidsFeature.getProperty("name_li")));
            feature.put("reli", this.toString(cidsFeature.getProperty("st_rl").equals(2)));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getSb(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_SB);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            CidsBean bean = cidsFeature.getBean();
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("nummer", this.toString(bean.getProperty("sb.sb"), false));
            feature.put("name", this.toString(bean.getProperty("sb.name")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getProfile(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_PROF);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("profil", this.toString(cidsFeature.getProperty("profil")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("ho_e", this.toString(cidsFeature.getProperty("ho_e")));
            feature.put("ho_a", this.toString(cidsFeature.getProperty("ho_a")));
            feature.put("gefaelle", this.toString(cidsFeature.getProperty("gefaelle")));
            feature.put("bv_re", this.toString(cidsFeature.getProperty("bv_re")));
            feature.put("bh_re", this.toString(cidsFeature.getProperty("bh_re")));
            feature.put("bl_re", this.toString(cidsFeature.getProperty("bl_re")));
            feature.put("bv_li", this.toString(cidsFeature.getProperty("bv_li")));
            feature.put("bh_li", this.toString(cidsFeature.getProperty("bh_li")));
            feature.put("bl_li", this.toString(cidsFeature.getProperty("bl_li")));
            feature.put("mw", this.toString(cidsFeature.getProperty("mw")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getSbef(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_SBEF);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("sbef", this.toString(cidsFeature.getProperty("sbef")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("ho_e", this.toString(cidsFeature.getProperty("ho_e")));
            feature.put("ho_a", this.toString(cidsFeature.getProperty("ho_a")));
            feature.put("gefaelle", this.toString(cidsFeature.getProperty("gefaelle")));
            feature.put("ho_d_e", this.toString(cidsFeature.getProperty("ho_d_e")));
            feature.put("ho_d_a", this.toString(cidsFeature.getProperty("ho_d_a")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getBbef(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_BBEF);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("bbef", this.toString(cidsFeature.getProperty("bbef")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("ho_d_o", this.toString(cidsFeature.getProperty("ho_d_o")));
            feature.put("ho_d_u", this.toString(cidsFeature.getProperty("ho_d_u")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getUbef(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_UBEF);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("ubef", this.toString(cidsFeature.getProperty("ubef")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("ho_d_o", this.toString(cidsFeature.getProperty("ho_d_o")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getRl(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_RL);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("profil", this.toString(cidsFeature.getProperty("profil")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            if (this.toString(cidsFeature.getProperty("profil")).equals("kr") || this.toString(cidsFeature.getProperty("profil")).equals("ei")) {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li"), false));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li"), false));
            } else {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li")));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li")));
            }
            feature.put("ho_e", this.toString(cidsFeature.getProperty("ho_e")));
            feature.put("ho_a", this.toString(cidsFeature.getProperty("ho_a")));
            feature.put("gefaelle", this.toString(cidsFeature.getProperty("gefaelle")));
            feature.put("br_tr_o_li", this.toString(cidsFeature.getProperty("br_tr_o_li")));
            feature.put("ho_d_e", this.toString(cidsFeature.getProperty("ho_d_e")));
            feature.put("ho_d_a", this.toString(cidsFeature.getProperty("ho_d_a")));
            feature.put("ho_d_m", this.toString(cidsFeature.getProperty("ho_d_m")));
            feature.put("mw", this.toString(cidsFeature.getProperty("mw")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getD(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_D);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("profil", this.toString(cidsFeature.getProperty("profil")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            if (this.toString(cidsFeature.getProperty("profil")).equals("kr") || this.toString(cidsFeature.getProperty("profil")).equals("ei")) {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li"), false));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li"), false));
            } else {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li")));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li")));
            }
            feature.put("ho_e", this.toString(cidsFeature.getProperty("ho_e")));
            feature.put("ho_a", this.toString(cidsFeature.getProperty("ho_a")));
            feature.put("gefaelle", this.toString(cidsFeature.getProperty("gefaelle")));
            feature.put("br_tr_o_li", this.toString(cidsFeature.getProperty("br_tr_o_li")));
            feature.put("ho_d_e", this.toString(cidsFeature.getProperty("ho_d_e")));
            feature.put("ho_d_a", this.toString(cidsFeature.getProperty("ho_d_a")));
            feature.put("ho_d_m", this.toString(cidsFeature.getProperty("ho_d_m")));
            feature.put("mw", this.toString(cidsFeature.getProperty("mw")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getDue(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_DUE);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("profil", this.toString(cidsFeature.getProperty("profil")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            if (this.toString(cidsFeature.getProperty("profil")).equals("kr") || this.toString(cidsFeature.getProperty("profil")).equals("ei")) {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li"), false));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li"), false));
            } else {
                feature.put("br_dm_li", this.toString(cidsFeature.getProperty("br_dm_li")));
                feature.put("ho_li", this.toString(cidsFeature.getProperty("ho_li")));
            }
            feature.put("ho_e", this.toString(cidsFeature.getProperty("ho_e")));
            feature.put("ho_a", this.toString(cidsFeature.getProperty("ho_a")));
            feature.put("gefaelle", this.toString(cidsFeature.getProperty("gefaelle")));
            feature.put("br_tr_o_li", this.toString(cidsFeature.getProperty("br_tr_o_li")));
            feature.put("ho_d_e", this.toString(cidsFeature.getProperty("ho_d_e")));
            feature.put("ho_d_a", this.toString(cidsFeature.getProperty("ho_d_a")));
            feature.put("ho_d_m", this.toString(cidsFeature.getProperty("ho_d_m")));
            feature.put("mw", this.toString(cidsFeature.getProperty("mw")));
            feature.put("ho_d_iab", this.toString(cidsFeature.getProperty("ho_d_iab")));
            feature.put("ho_d_iauf", this.toString(cidsFeature.getProperty("ho_d_iauf")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getScha(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_SCHA);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("scha", this.toString(cidsFeature.getProperty("scha")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("ho_so", this.toString(cidsFeature.getProperty("ho_so")));
            feature.put("ho_d_so_ok", this.toString(cidsFeature.getProperty("ho_d_so_ok")));
            feature.put("material", this.toString(cidsFeature.getProperty("material")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getWehr(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_WEHR);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("wehr", this.toString(cidsFeature.getProperty("wehr")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("br_li", this.toString(cidsFeature.getProperty("br_li")));
            feature.put("ho_so", this.toString(cidsFeature.getProperty("ho_so")));
            feature.put("sz", this.toString(cidsFeature.getProperty("sz")));
            feature.put("az", this.toString(cidsFeature.getProperty("az")));
            feature.put("wehr_v", this.toString(cidsFeature.getProperty("wehr_v")));
            feature.put("wehr_av", this.toString(cidsFeature.getProperty("wehr_av")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("material_v", this.toString(cidsFeature.getProperty("material_v")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getSchw(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_SCHW);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("schw", this.toString(cidsFeature.getProperty("schw")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("ho_so", this.toString(cidsFeature.getProperty("ho_so")));
            feature.put("sz", this.toString(cidsFeature.getProperty("sz")));
            feature.put("az", this.toString(cidsFeature.getProperty("az")));
            feature.put("ezg_fl", this.toString(cidsFeature.getProperty("ezg_fl")));
            feature.put("v_fl", this.toString(cidsFeature.getProperty("v_fl")));
            feature.put("pu", this.toString(cidsFeature.getProperty("pu")));
            feature.put("pu_foel", this.toString(cidsFeature.getProperty("pu_foel")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getAnlp(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_ANLP);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("anlp", this.toString(cidsFeature.getProperty("anlp")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getKr(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_KR);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("kr", this.toString(cidsFeature.getProperty("kr")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_oiu")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getEa(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_EA);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("ea", this.toString(cidsFeature.getProperty("ea")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("lage_og", this.toString(cidsFeature.getProperty("l_og")));
            feature.put("ho_ea", this.toString(cidsFeature.getProperty("ho_ea")));
            feature.put("ho_d_ea", this.toString(cidsFeature.getProperty("ho_d_ea")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getUghz(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_UGHZ);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("ughz", this.toString(cidsFeature.getProperty("ughz")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("ho_d_o", this.toString(cidsFeature.getProperty("ho_d_o")));
            feature.put("ho_d_u", this.toString(cidsFeature.getProperty("ho_d_u")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getLeis(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_LEIS);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("leis", this.toString(cidsFeature.getProperty("leis")));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getTech(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_TECH);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("tech", this.toString(cidsFeature.getProperty("tech")));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("na_gu", this.toString(cidsFeature.getProperty("na_gu"), false));
            feature.put("mahd_gu", this.toString(cidsFeature.getProperty("mahd_gu"), false));
            feature.put("gu_gu", this.toString(cidsFeature.getProperty("gu_gu"), false));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getDok(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_DOK);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("name", this.toString(cidsFeature.getProperty("name")));
            feature.put("objnr", this.toString(cidsFeature.getProperty("doc_nr"), false));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("doc_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getProj(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_PROJ);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("name", this.toString(cidsFeature.getProperty("name")));
            feature.put("objnr", this.toString(cidsFeature.getProperty("proj_nr"), false));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("proj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getDeich(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_DEICH);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("km_von", this.toString(cidsFeature.getProperty("km_von")));
            feature.put("km_bis", this.toString(cidsFeature.getProperty("km_bis")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("lage_bd", this.toString(cidsFeature.getProperty("l_fk")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("deich", this.toString(cidsFeature.getProperty("deich")));
            feature.put("ord", this.toString(cidsFeature.getProperty("ord")));
            feature.put("sg", this.toString(cidsFeature.getProperty("schgr")));
            feature.put("berme_w", this.toX(cidsFeature.getProperty("berme_w")));
            feature.put("berme_b", this.toX(cidsFeature.getProperty("berme_b")));
            feature.put("material_f", this.toString(cidsFeature.getProperty("material_f")));
            feature.put("material_w", this.toString(cidsFeature.getProperty("material_w")));
            feature.put("material_k", this.toString(cidsFeature.getProperty("material_k")));
            feature.put("material_i", this.toString(cidsFeature.getProperty("material_i")));
            feature.put("material_b", this.toString(cidsFeature.getProperty("material_b")));
            feature.put("name", this.toString(cidsFeature.getProperty("name")));
            feature.put("nummer", this.toString(cidsFeature.getProperty("nr")));
            feature.put("br_f", this.toString(cidsFeature.getProperty("br_f")));
            feature.put("br_k", this.toString(cidsFeature.getProperty("br_k")));
            feature.put("ho_k_f", this.toString(cidsFeature.getProperty("ho_k_f")));
            feature.put("ho_k_pn", this.toString(cidsFeature.getProperty("ho_k_pn")));
            feature.put("ho_bhw_pn", this.toString(cidsFeature.getProperty("ho_bhw_pn")));
            feature.put("ho_mw_pn", this.toString(cidsFeature.getProperty("ho_mw_pn")));
            feature.put("bv_w", this.toString(cidsFeature.getProperty("bv_w")));
            feature.put("bv_b", this.toString(cidsFeature.getProperty("bv_b")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getFoto(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FOTO);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("titel", this.toString(cidsFeature.getProperty("titel")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("lage", this.toString(cidsFeature.getProperty("l_rl")));
            feature.put("datum", this.toString(cidsFeature.getProperty("aufn_datum")));
            feature.put("winkel", this.toString(cidsFeature.getProperty("winkel")));
            feature.put("zeit", this.toString(cidsFeature.getProperty("aufn_zeit")));
            feature.put("obj_nr", this.toString(cidsFeature.getProperty("foto_nr"), false));
            feature.put("freigabe", this.toString(cidsFeature.getProperty("freigabe")));
            feature.put("beschreibung", this.toString(cidsFeature.getProperty("beschreib")));
            feature.put("foto_nr_gu", this.toString(cidsFeature.getProperty("foto_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getAnll(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(FG_BA_ANLL);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st_von");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("von", this.convertStation((Double)cidsFeature.getProperty("ba_st_von")));
            feature.put("bis", this.convertStation((Double)cidsFeature.getProperty("ba_st_bis")));
            feature.put("lagestatus", this.toString(cidsFeature.getProperty("l_st")));
            feature.put("anll", this.toString(cidsFeature.getProperty("anll")));
            feature.put("traeger", this.toString(cidsFeature.getProperty("traeger")));
            feature.put("jahr", this.toString(cidsFeature.getProperty("ausbaujahr"), false));
            feature.put("zk", this.toString(cidsFeature.getProperty("zust_kl"), false));
            feature.put("objnr", this.toString(cidsFeature.getProperty("obj_nr"), false));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            feature.put("bemerkungen", this.toString(cidsFeature.getProperty("bemerkung")));
            feature.put("br", this.toString(cidsFeature.getProperty("br")));
            feature.put("esw", this.toX(cidsFeature.getProperty("esw")));
            feature.put("laenge", this.toString(cidsFeature.getProperty("laenge")));
            feature.put("traeger_gu", this.toString(cidsFeature.getProperty("traeger_gu")));
            feature.put("objnr_gu", this.toString(cidsFeature.getProperty("obj_nr_gu"), false));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getWasserrechtAusbau(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(WR_WBU_AUS);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("kurzbeschreibung", this.toStringWithoutNull(cidsFeature.getProperty("wbausbau1")) + (cidsFeature.getProperty("wbausbau1") != null ? " " : "") + this.toStringWithoutNull(cidsFeature.getProperty("wbausbau2")));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getPegel(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(MN_OW_PEGEL);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("nummer", this.toString(cidsFeature.getProperty("ms_nr"), false));
            feature.put("nummer_wsa", this.toString(cidsFeature.getProperty("ms_nr_wsa"), false));
            feature.put("name", this.toString(cidsFeature.getProperty("ms_name")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private JRDataSource getWasserrechtBenutzung(String baCd) throws Exception {
        CidsLayer cl = this.createCidsLayer(WR_WBU_BEN);
        String query = cl.decoratePropertyName("ba_cd") + " = '" + baCd + "'";
        FeatureServiceAttribute fsa = (FeatureServiceAttribute)cl.getFeatureServiceAttributes().get("ba_st");
        fsa.setAscOrder(true);
        List featureList = cl.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, new FeatureServiceAttribute[]{fsa});
        ArrayList<Map<String, String>> features = new ArrayList<Map<String, String>>();
        for (CidsLayerFeature cidsFeature : featureList) {
            HashMap<String, String> feature = new HashMap<String, String>();
            feature.put("station", this.convertStation((Double)cidsFeature.getProperty("ba_st")));
            feature.put("kurzbeschreibung", this.toStringWithoutNull(cidsFeature.getProperty("wbbenzw1")) + (cidsFeature.getProperty("wbbenzw1") != null ? " " : "") + this.toStringWithoutNull(cidsFeature.getProperty("wbbenzw2")));
            feature.put("wbbl", this.toString(cidsFeature.getProperty("wbbl")));
            features.add(feature);
        }
        return new FeatureDataSource(features);
    }

    private String toStringWithoutNull(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    private String toString(Object o, boolean formatObject) {
        if (o == null) {
            return null;
        }
        if (!formatObject) {
            return String.valueOf(o);
        }
        if (o instanceof Double || o instanceof Integer) {
            return formatter.format(o);
        }
        if (o instanceof Date) {
            return DateFormat.getDateInstance().format((Date)o);
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return "X";
            }
            return null;
        }
        return String.valueOf(o);
    }

    private String toString(Object o) {
        return this.toString(o, true);
    }

    private String toX(Object o) {
        if (o instanceof Number && ((Number)o).intValue() == 1) {
            return "X";
        }
        return "";
    }

    private CidsLayer createCidsLayer(MetaClass mo) throws Exception {
        CidsLayer layer = layerMap.get(mo.getTableName());
        if (layer == null) {
            layer = new CidsLayer(mo);
            layer.initAndWait();
            layerMap.put(mo.getTableName(), layer);
        }
        return layer;
    }

    public void cleanup() {
        layerMap.clear();
    }

    private String convertStation(Double station) {
        if (station == null) {
            return "";
        }
        return this.toString(station, true);
    }

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMinimumFractionDigits(2);
        formatter.setGroupingSize(3);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        layerMap = new HashMap<String, CidsLayer>();
    }

    private class FeatureDataSource
    implements JRRewindableDataSource {
        private int index = -1;
        private final List<Map<String, String>> features;

        public FeatureDataSource(FeatureDataSource copy) {
            this.features = copy.features;
        }

        public FeatureDataSource(List<Map<String, String>> features) {
            this.features = features;
        }

        public boolean next() throws JRException {
            boolean result;
            ++this.index;
            if (this.features.isEmpty() && this.index == 0) {
                return true;
            }
            boolean bl = result = this.index < this.features.size();
            if (!result) {
                this.index = -1;
            }
            return result;
        }

        public Object getFieldValue(JRField jrf) throws JRException {
            if (this.features.isEmpty()) {
                return null;
            }
            return this.features.get(this.index).get(jrf.getName());
        }

        public void moveFirst() throws JRException {
            this.index = 0;
        }
    }

    private class GewaesserDataSource
    implements JRDataSource {
        private boolean first = true;
        private final String gewaessercode;
        private final String unterhalter;
        private final String gewaessername;
        private final String laenge;
        private final String ordnung;
        private final String datum;

        public GewaesserDataSource(String gewaessercode, String unterhalter, String gewaessername, String laenge, String ordnung, String datum) {
            this.gewaessercode = gewaessercode;
            this.unterhalter = unterhalter;
            this.gewaessername = gewaessername;
            this.laenge = laenge;
            this.ordnung = ordnung;
            this.datum = datum;
        }

        public boolean next() throws JRException {
            if (this.first) {
                this.first = false;
                return true;
            }
            return false;
        }

        public Object getFieldValue(JRField jrf) throws JRException {
            if (jrf.getName().equals("gewaessercode")) {
                return this.gewaessercode;
            }
            if (jrf.getName().equals("unterhalter")) {
                return this.unterhalter;
            }
            if (jrf.getName().equals("gewaessername")) {
                return this.gewaessername;
            }
            if (jrf.getName().equals("laenge")) {
                return this.laenge;
            }
            if (jrf.getName().equals("ordnung")) {
                return this.ordnung;
            }
            if (jrf.getName().equals("datum")) {
                return this.datum;
            }
            return null;
        }
    }

    class topoFeatureCalc {
        Map<String[], List<CidsLayerFeature>> featureMap = new HashMap<String[], List<CidsLayerFeature>>();
        TreeSet<Double> stations = new TreeSet();

        topoFeatureCalc() {
        }

        public void addFeatures(List<CidsLayerFeature> features, String fAttr, String mapAttr) {
            if (!features.isEmpty()) {
                this.featureMap.put(new String[]{fAttr, mapAttr}, features);
                for (CidsLayerFeature f : features) {
                    this.stations.add((Double)f.getProperty("bak_st_von"));
                    this.stations.add((Double)f.getProperty("bak_st_bis"));
                }
            }
        }

        public List<Map<String, String>> calcResult() {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            Double lastStation = null;
            for (Double s : this.stations) {
                Map<String, String> entry;
                if (lastStation != null && (entry = this.createMap(lastStation, s)) != null) {
                    result.add(entry);
                }
                lastStation = s;
            }
            return result;
        }

        private Map<String, String> createMap(Double start, Double end) {
            HashMap<String, String> map = new HashMap<String, String>();
            Double pointInTheMiddle = start + 0.0012;
            boolean attrFound = false;
            map.put("von", GewaesserReport.this.convertStation(start));
            map.put("bis", GewaesserReport.this.convertStation(end));
            map.put("laenge", GewaesserReport.this.toString(Math.abs(end - start)));
            for (String[] key : this.featureMap.keySet()) {
                for (CidsLayerFeature f : this.featureMap.get(key)) {
                    Double von = Math.min((Double)f.getProperty("bak_st_von"), (Double)f.getProperty("bak_st_bis"));
                    Double bis = Math.max((Double)f.getProperty("bak_st_von"), (Double)f.getProperty("bak_st_bis"));
                    if (!(von < pointInTheMiddle) || !(bis > pointInTheMiddle)) continue;
                    map.put(key[1], GewaesserReport.this.toString(f.getProperty(key[0])));
                    attrFound = true;
                }
            }
            if (attrFound) {
                return map;
            }
            return null;
        }
    }
}

