/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllLineObjects;
import de.cismet.cids.custom.watergis.server.search.AllPunktObjects;
import de.cismet.cids.custom.watergis.server.search.SchuUeberReport;
import de.cismet.cids.custom.watergis.server.search.SchuWasserReport;
import de.cismet.cids.server.search.CidsServerSearch;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class KatasterFlaechenData {
    private Map<LineFromPolygonTable, List<LineObjectData>> lineFromPolygonMap = new EnumMap<LineFromPolygonTable, List<LineObjectData>>(LineFromPolygonTable.class);
    private Map<AllLineObjects.Table, List<LineObjectData>> lineMap = new EnumMap<AllLineObjects.Table, List<LineObjectData>>(AllLineObjects.Table.class);
    private Map<AllPunktObjects.Table, List<PointObjectData>> pointMap = new EnumMap<AllPunktObjects.Table, List<PointObjectData>>(AllPunktObjects.Table.class);
    private Object attr2;

    public KatasterFlaechenData(Object attr, Object attr2, int[] gew) throws Exception {
        this.attr2 = attr2;
        this.init(gew);
    }

    private void init(int[] gew) throws Exception {
        this.lineMap.put(AllLineObjects.Table.fg_ba_d, this.createDataObjects(AllLineObjects.Table.fg_ba_d, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_anll, this.createDataObjects(AllLineObjects.Table.fg_ba_anll, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_bbef, this.createDataObjects(AllLineObjects.Table.fg_ba_bbef, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_due, this.createDataObjects(AllLineObjects.Table.fg_ba_due, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_gb, this.createDataObjects(AllLineObjects.Table.fg_ba_gb, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_gmd, this.createDataObjects(AllLineObjects.Table.fg_ba_gmd, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_leis, this.createDataObjects(AllLineObjects.Table.fg_ba_leis, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_prof, this.createDataObjects(AllLineObjects.Table.fg_ba_prof, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_rl, this.createDataObjects(AllLineObjects.Table.fg_ba_rl, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_sb, this.createDataObjects(AllLineObjects.Table.fg_ba_sb, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_sbef, this.createDataObjects(AllLineObjects.Table.fg_ba_sbef, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_tech, this.createDataObjects(AllLineObjects.Table.fg_ba_tech, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_doku, this.createDataObjects(AllLineObjects.Table.fg_ba_doku, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_proj, this.createDataObjects(AllLineObjects.Table.fg_ba_proj, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_ubef, this.createDataObjects(AllLineObjects.Table.fg_ba_ubef, gew));
        this.lineMap.put(AllLineObjects.Table.fg_ba_ughz, this.createDataObjects(AllLineObjects.Table.fg_ba_ughz, gew));
        this.lineMap.put(AllLineObjects.Table.deich_ft, this.createDataObjects(AllLineObjects.Table.deich_ft, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_anlp, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_anlp, gew));
        this.pointMap.put(AllPunktObjects.Table.wr_wbu_aus, this.createPointDataObjects(AllPunktObjects.Table.wr_wbu_aus, gew));
        this.pointMap.put(AllPunktObjects.Table.wr_wbu_ben, this.createPointDataObjects(AllPunktObjects.Table.wr_wbu_ben, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_kr, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_kr, gew));
        this.pointMap.put(AllPunktObjects.Table.mn_ow_pegel, this.createPointDataObjects(AllPunktObjects.Table.mn_ow_pegel, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_scha, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_scha, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_schw, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_schw, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_wehr, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_wehr, gew));
        this.pointMap.put(AllPunktObjects.Table.fg_ba_ea, this.createPointDataObjects(AllPunktObjects.Table.fg_ba_ea, gew));
        this.pointMap.put(AllPunktObjects.Table.foto, this.createPointDataObjects(AllPunktObjects.Table.foto, gew));
        this.lineFromPolygonMap.put(LineFromPolygonTable.sg_see, this.createSee(gew));
        this.lineFromPolygonMap.put(LineFromPolygonTable.wr_sg_uesg, this.createSchutzUeber(gew));
        this.lineFromPolygonMap.put(LineFromPolygonTable.wr_sg_wsg, this.createSchutzWasser(gew));
    }

    public Object getAttr2() {
        return this.attr2;
    }

    public int getCount(AllPunktObjects.Table table, int gew, double from, double till) {
        List<PointObjectData> points = this.pointMap.get(table);
        int count = 0;
        if (points != null) {
            for (PointObjectData pointObj : points) {
                if (!pointObj.isInGewPart(gew, from, till)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getCount(AllLineObjects.Table table, int gew, double from, double till) {
        List<LineObjectData> lines = this.lineMap.get(table);
        int count = 0;
        if (lines != null) {
            for (LineObjectData lineObj : lines) {
                if (!lineObj.isInGewPart(gew, from, till)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getLength(AllLineObjects.Table table, int gew, double from, double till) {
        List<LineObjectData> lines = this.lineMap.get(table);
        int length = 0;
        if (lines != null) {
            for (LineObjectData lineObj : lines) {
                length = (int)((double)length + lineObj.getLengthInGewPart(gew, from, till));
            }
        }
        return length;
    }

    public int getCount(LineFromPolygonTable table, int gew, double from, double till) {
        List<LineObjectData> lines = this.lineFromPolygonMap.get((Object)table);
        int count = 0;
        if (lines != null) {
            for (LineObjectData lineObj : lines) {
                if (!lineObj.isInGewPart(gew, from, till)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getLength(LineFromPolygonTable table, int gew, double from, double till) {
        List<LineObjectData> lines = this.lineFromPolygonMap.get((Object)table);
        int length = 0;
        if (lines != null) {
            for (LineObjectData lineObj : lines) {
                length = (int)((double)length + lineObj.getLengthInGewPart(gew, from, till));
            }
        }
        return length;
    }

    private List<LineObjectData> createSchutzWasser(int[] gew) throws Exception {
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new SchuWasserReport(gew));
        ArrayList<LineObjectData> objList = new ArrayList<LineObjectData>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new LineObjectData((Integer)f.get(3), (String)f.get(2), (Double)f.get(0), (Double)f.get(1), (Double)f.get(1) - (Double)f.get(0)));
            }
        }
        return objList;
    }

    private List<LineObjectData> createSchutzUeber(int[] gew) throws Exception {
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new SchuUeberReport(gew));
        ArrayList<LineObjectData> objList = new ArrayList<LineObjectData>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new LineObjectData((Integer)f.get(3), (String)f.get(2), (Double)f.get(0), (Double)f.get(1), (Double)f.get(1) - (Double)f.get(0)));
            }
        }
        return objList;
    }

    private List<LineObjectData> createSee(int[] gew) throws Exception {
        ArrayList<LineObjectData> objList = new ArrayList<LineObjectData>();
        return objList;
    }

    private List<LineObjectData> createDataObjects(AllLineObjects.Table table, int[] gew) throws Exception {
        AllLineObjects search = new AllLineObjects(table, gew);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<LineObjectData> objList = new ArrayList<LineObjectData>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new LineObjectData((Integer)f.get(0), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), (Double)f.get(1)));
            }
        }
        return objList;
    }

    private List<PointObjectData> createPointDataObjects(AllPunktObjects.Table table, int[] gew) throws Exception {
        AllPunktObjects search = new AllPunktObjects(table, gew);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<PointObjectData> objList = new ArrayList<PointObjectData>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new PointObjectData((Integer)f.get(0), (String)f.get(1), (Double)f.get(2)));
            }
        }
        return objList;
    }

    private class LineObjectData {
        private int gewId;
        private String baCd;
        private double from;
        private double to;
        private double length;

        public LineObjectData() {
        }

        public LineObjectData(int gewId, String baCd, double from, double to, double length) {
            this.gewId = gewId;
            this.baCd = baCd;
            this.from = from;
            this.to = to;
            this.length = length;
        }

        public boolean isInGewPart(int gew, double from, double till) {
            return gew == this.gewId && Math.min(Math.max(this.from, this.to), Math.max(from, till)) - Math.max(Math.min(this.from, this.to), Math.min(from, till)) > 0.1;
        }

        public double getLengthInGewPart(int gew, double from, double till) {
            if (gew == this.gewId) {
                return Math.max(0.0, Math.min(Math.max(this.from, this.to), Math.max(from, till)) - Math.max(Math.min(this.from, this.to), Math.min(from, till)));
            }
            return 0.0;
        }

        public String getBaCd() {
            return this.baCd;
        }

        public void setBaCd(String baCd) {
            this.baCd = baCd;
        }

        public double getFrom() {
            return this.from;
        }

        public void setFrom(double from) {
            this.from = from;
        }

        public double getTo() {
            return this.to;
        }

        public void setTo(double to) {
            this.to = to;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }
    }

    private class PointObjectData {
        private int gewId;
        private String baCd;
        private double from;

        public PointObjectData() {
        }

        public PointObjectData(int gewId, String baCd, double from) {
            this.gewId = gewId;
            this.baCd = baCd;
            this.from = from;
        }

        public boolean isInGewPart(int gew, double from, double till) {
            return gew == this.gewId && Math.min(from, till) <= this.from && Math.max(from, till) >= from;
        }

        public String getBaCd() {
            return this.baCd;
        }

        public void setBaCd(String baCd) {
            this.baCd = baCd;
        }

        public double getFrom() {
            return this.from;
        }

        public void setFrom(double from) {
            this.from = from;
        }
    }

    public static enum LineFromPolygonTable {
        sg_see,
        wr_sg_wsg,
        wr_sg_uesg;

    }
}

