/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import de.cismet.cids.custom.beans.watergis.Bookmark;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.bookmarks.MenuBookMarkAction;
import de.cismet.watergis.gui.recently_opened_files.RecentlyOpenedFilesList;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.util.Exceptions;

public class BookmarkManager
implements Configurable {
    private static final Logger LOG = Logger.getLogger(RecentlyOpenedFilesList.class);
    private static final String XML_ENCODING;
    private String bookmarkFilePath = WatergisApp.getDIRECTORYPATH_WATERGIS() + System.getProperty("file.separator") + "bookmarks.lz";
    private ArrayList<Bookmark> bookmarkList = new ArrayList();
    private HashMap<Bookmark, JMenuItem> bookmarkMenuItemMap = new HashMap();
    private JPopupMenu.Separator separator;

    public void add(Bookmark bookmark) {
        this.bookmarkList.add(bookmark);
        JMenu menu = (JMenu)AppBroker.getInstance().getComponent(ComponentName.MENU_BOOKMARK);
        if (this.separator == null) {
            this.separator = new JPopupMenu.Separator();
            menu.add(this.separator);
        }
        MenuBookMarkAction action = new MenuBookMarkAction(bookmark);
        JMenuItem menuItem = new JMenuItem();
        menuItem.setAction(action);
        menu.add((Component)menuItem, 3);
        this.bookmarkMenuItemMap.put(bookmark, menuItem);
        Collections.sort(this.bookmarkList);
    }

    public void remove(Bookmark bookmark) {
        this.bookmarkList.remove(bookmark);
        JMenu menu = (JMenu)AppBroker.getInstance().getComponent(ComponentName.MENU_BOOKMARK);
        menu.remove(this.bookmarkMenuItemMap.get(bookmark));
        this.bookmarkMenuItemMap.remove(bookmark);
        if (this.bookmarkList.isEmpty()) {
            menu.remove(this.separator);
            this.separator = null;
        }
    }

    private void clean() {
        ArrayList<Bookmark> tmpList = new ArrayList<Bookmark>();
        tmpList.addAll(this.bookmarkList);
        for (Bookmark bm : tmpList) {
            this.remove(bm);
        }
    }

    public Collection<Bookmark> getBookmarks() {
        return this.bookmarkList;
    }

    public void configure(Element parent) {
        this.loadFromFile(new File(this.bookmarkFilePath));
    }

    public void masterConfigure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        this.saveToFile(new File(this.bookmarkFilePath));
        return null;
    }

    public void loadFromFile(File bookmarkFile) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(bookmarkFile);
            Element rootObject = doc.getRootElement();
            if (rootObject != null) {
                Element bookmarkListElement = rootObject.getChild("bookmarks");
                List bookmarks = bookmarkListElement.getChildren("bookmark");
                this.clean();
                for (int i = 0; i < bookmarks.size(); ++i) {
                    this.add(new Bookmark((Element)bookmarks.get(i)));
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while reading the bookmars from the file" + bookmarkFile.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) {
        OutputStreamWriter writer = null;
        try {
            Element root = new Element("bookmarkManager");
            Element bookmarks = new Element("bookmarks");
            for (int i = 0; i < this.bookmarkList.size(); ++i) {
                bookmarks.addContent((Content)this.bookmarkList.get(i).toElement());
            }
            root.addContent((Content)bookmarks);
            Document doc = new Document(root);
            Format format = Format.getPrettyFormat();
            format.setEncoding(XML_ENCODING);
            XMLOutputter serializer = new XMLOutputter(format);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), XML_ENCODING);
            serializer.output(doc, (Writer)writer);
            writer.flush();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while saving bookmarks", (Throwable)ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static {
        String charset = Charset.defaultCharset().toString();
        XML_ENCODING = "MacRoman".equals(charset) ? "UTF-8" : "ISO-8859-1";
    }
}

