/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PersistentFeature;
import de.cismet.cismap.commons.util.FilePersistenceManager;
import java.sql.Timestamp;
import java.util.Date;

public class JumpFeature
implements Feature {
    private static final boolean DATE_AS_STRING = true;
    private final FeatureServiceFeature feature;
    private FeatureSchema schema = null;

    public JumpFeature(FeatureServiceFeature feature) {
        this.feature = feature;
    }

    public JumpFeature(FeatureServiceFeature feature, FeatureSchema schema) {
        this.feature = feature;
        this.schema = schema;
    }

    public FilePersistenceManager getPersistenceManager() {
        if (this.feature instanceof PersistentFeature) {
            return ((PersistentFeature)this.feature).getPersistenceManager();
        }
        return null;
    }

    public void setAttributes(Object[] attributes) {
    }

    public void setSchema(FeatureSchema schema) {
        this.schema = schema;
    }

    public int getID() {
        return this.feature.getId();
    }

    public void setAttribute(int attributeIndex, Object newAttribute) {
    }

    public void setAttribute(String attributeName, Object newAttribute) {
    }

    public void setGeometry(Geometry geometry) {
    }

    public Object getAttribute(int i) {
        Object value = this.feature.getProperty(this.schema.getAttributeName(i));
        if (value instanceof Boolean) {
            value = String.valueOf(value);
        } else if (value instanceof Timestamp || value instanceof Date) {
            value = String.valueOf(value);
        }
        if (this.schema.getAttributeType(this.schema.getAttributeName(i)) == AttributeType.DOUBLE && value instanceof Integer) {
            value = ((Integer)value).doubleValue();
        }
        return value;
    }

    public Object getAttribute(String name) {
        return this.feature.getProperty(name);
    }

    public String getString(int attributeIndex) {
        Object value = this.feature.getProperty(this.schema.getAttributeName(attributeIndex));
        if (value instanceof Boolean) {
            value = String.valueOf(value);
        } else if (value instanceof Timestamp || value instanceof Date) {
            value = String.valueOf(value);
        }
        return (String)value;
    }

    public int getInteger(int attributeIndex) {
        return (Integer)this.feature.getProperty(this.schema.getAttributeName(attributeIndex));
    }

    public double getDouble(int attributeIndex) {
        return (Double)this.feature.getProperty(this.schema.getAttributeName(attributeIndex));
    }

    public String getString(String attributeName) {
        return (String)this.feature.getProperty(attributeName);
    }

    public Geometry getGeometry() {
        return this.feature.getGeometry();
    }

    public FeatureSchema getSchema() {
        return this.schema;
    }

    public Feature clone(boolean deep) {
        return new JumpFeature(this.feature);
    }

    public Object[] getAttributes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareTo(Object o) {
        if (o instanceof JumpFeature) {
            return this.feature.getId() - ((JumpFeature)o).getID();
        }
        return -1;
    }

    public Object clone() {
        return new JumpFeature(this.feature);
    }
}

