/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LinkTableCellRenderer
extends DefaultTableCellRenderer {
    private int alignment = 2;
    private final boolean showFullLink;

    public LinkTableCellRenderer() {
        this(true);
    }

    public LinkTableCellRenderer(boolean showFullLink) {
        this.showFullLink = showFullLink;
    }

    public LinkTableCellRenderer(int alignment) {
        this.alignment = alignment;
        this.showFullLink = true;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            ((JLabel)c).setForeground(Color.BLUE);
            Font underlinedFont = ((JLabel)c).getFont();
            Map<TextAttribute, ?> attributes = underlinedFont.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            ((JLabel)c).setFont(underlinedFont.deriveFont(attributes));
            ((JLabel)c).setHorizontalAlignment(this.alignment);
            if (!this.showFullLink) {
                ((JLabel)c).setText("Link");
            }
        }
        return c;
    }
}

