/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import de.cismet.cismap.commons.util.FilePersistenceManager;

public class PersistentGeometryWrapper
extends Geometry {
    Feature feature = null;

    public PersistentGeometryWrapper(GeometryFactory factory, Feature f) {
        super(factory);
        this.feature = f;
    }

    public PersistentGeometryWrapper(GeometryFactory factory, Geometry geo, FilePersistenceManager pm) {
        super(factory);
        this.feature = new SimpleGeometryFeature(geo, pm);
    }

    public Geometry getGeom() {
        return this.feature.getGeometry();
    }

    public String getGeometryType() {
        return this.getGeom().getGeometryType();
    }

    public Coordinate getCoordinate() {
        return this.getGeom().getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        return this.getGeom().getCoordinates();
    }

    public int getNumPoints() {
        return this.getGeom().getNumPoints();
    }

    public boolean isEmpty() {
        return this.getGeom().isEmpty();
    }

    public int getDimension() {
        return this.getGeom().getDimension();
    }

    public Geometry getBoundary() {
        return this.getGeom().getBoundary();
    }

    public int getBoundaryDimension() {
        return this.getGeom().getBoundaryDimension();
    }

    public Geometry reverse() {
        return this.getGeom().reverse();
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        return this.getGeom().equalsExact(other, tolerance);
    }

    public void apply(CoordinateFilter filter) {
        this.getGeom().apply(filter);
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.getGeom().apply(filter);
    }

    public void apply(GeometryFilter filter) {
        this.getGeom().apply(filter);
    }

    public void apply(GeometryComponentFilter filter) {
        this.getGeom().apply(filter);
    }

    public void normalize() {
        this.getGeom().normalize();
    }

    protected Envelope computeEnvelopeInternal() {
        Geometry envGeom = this.getGeom().getEnvelope();
        CoordinateSequence s = envGeom.getFactory().getCoordinateSequenceFactory().create(envGeom.getCoordinates());
        return s.expandEnvelope(new Envelope());
    }

    protected int compareToSameClass(Object o) {
        return this.getGeom().compareTo(o);
    }

    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        return this.getGeom().compareTo(o, comp);
    }

    private static class SimpleGeometryFeature
    implements Feature {
        FilePersistenceManager pm;
        long geoId;

        public SimpleGeometryFeature(Geometry geo, FilePersistenceManager pm) {
            this.pm = pm;
            this.geoId = pm.save((Object)geo);
        }

        public Object clone() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttributes(Object[] attributes) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setSchema(FeatureSchema schema) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttribute(int attributeIndex, Object newAttribute) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttribute(String attributeName, Object newAttribute) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setGeometry(Geometry geometry) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getAttribute(int i) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getString(int attributeIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getInteger(int attributeIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double getDouble(int attributeIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getString(String attributeName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Geometry getGeometry() {
            return (Geometry)this.pm.load(this.geoId);
        }

        public FeatureSchema getSchema() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Feature clone(boolean deep) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object[] getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

