/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import de.cismet.cismap.commons.util.FilePersistenceManager;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.utils.GeometryCollectionWrapper;
import de.cismet.watergis.utils.JumpFeature;
import de.cismet.watergis.utils.PersistentGeometryWrapper;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFile;
import org.geotools.dbffile.DbfFileWriter;
import org.geotools.shapefile.Shapefile;

public class ShapefileWriter
implements JUMPWriter {
    public static final String FILE_PROPERTY_KEY = "File";
    public static final String DEFAULT_VALUE_PROPERTY_KEY = "DefaultValue";
    public static final String SHAPE_TYPE_PROPERTY_KEY = "ShapeType";
    public static boolean truncate = false;
    private static long lastTimeTruncate = new Date(0L).getTime();
    protected static CGAlgorithms cga = new RobustCGAlgorithms();
    private WatergisDefaultRuleSet ruleSet = null;
    private Map<String, String> aliasNameToNameMap = new HashMap<String, String>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception {
        this.checkIfGeomsAreMixed(featureCollection);
        String shpfileName = dp.getProperty(FILE_PROPERTY_KEY);
        if (shpfileName == null) {
            shpfileName = dp.getProperty(DEFAULT_VALUE_PROPERTY_KEY);
        }
        if (shpfileName == null) {
            throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.no-output-filename-specified"));
        }
        int loc = shpfileName.lastIndexOf(File.separatorChar);
        if (loc == -1) {
            throw new Exception(I18N.getMessage((String)"io.ShapefileWriter.path-separator-not-found", (Object[])new Object[]{Character.valueOf(File.separatorChar)}));
        }
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.filename-must-end-in-shp"));
        }
        String fname_withoutextention = fname.substring(0, loc);
        String dbffname = path + fname_withoutextention + ".dbf";
        String charsetName = dp.getProperty("charset");
        if (charsetName == null) {
            charsetName = Charset.defaultCharset().name();
        }
        this.writeDbf(featureCollection, dbffname, Charset.forName(charsetName));
        GeometryCollection gc = this.makeSHAPEGeometryCollection(featureCollection);
        int shapeType = 2;
        if (dp.getProperty(SHAPE_TYPE_PROPERTY_KEY) != null) {
            String st = dp.getProperty(SHAPE_TYPE_PROPERTY_KEY);
            if (st.equalsIgnoreCase("xy")) {
                shapeType = 2;
            } else if (st.equalsIgnoreCase("xym")) {
                shapeType = 3;
            } else if (st.equalsIgnoreCase("xymz")) {
                shapeType = 4;
            } else if (st.equalsIgnoreCase("xyzm")) {
                shapeType = 4;
            } else {
                if (!st.equalsIgnoreCase("xyz")) throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.unknown-type"));
                shapeType = 4;
            }
        } else if (gc.getNumGeometries() > 0) {
            shapeType = this.guessCoordinateDims(gc.getGeometryN(0));
        }
        URL url = new URL("file", "localhost", shpfileName);
        Shapefile myshape = new Shapefile(url);
        myshape.write(gc, shapeType);
        String shxfname = path + fname_withoutextention + ".shx";
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(shxfname));
        EndianDataOutputStream sfile = new EndianDataOutputStream((OutputStream)in);
        myshape.writeIndex(gc, sfile, shapeType);
        if (!truncate) return;
        lastTimeTruncate = new Date().getTime();
    }

    public void setRuleSet(WatergisDefaultRuleSet ruleSet, Map<String, String> aliasNameToNameMap) {
        this.ruleSet = ruleSet;
        if (aliasNameToNameMap != null) {
            this.aliasNameToNameMap = aliasNameToNameMap;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePersistentFeatures(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception, InterruptedException {
        String shpfileName = dp.getProperty(FILE_PROPERTY_KEY);
        if (shpfileName == null) {
            shpfileName = dp.getProperty(DEFAULT_VALUE_PROPERTY_KEY);
        }
        if (shpfileName == null) {
            throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.no-output-filename-specified"));
        }
        int loc = shpfileName.lastIndexOf(File.separatorChar);
        if (loc == -1) {
            throw new Exception(I18N.getMessage((String)"io.ShapefileWriter.path-separator-not-found", (Object[])new Object[]{Character.valueOf(File.separatorChar)}));
        }
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.filename-must-end-in-shp"));
        }
        String fname_withoutextention = fname.substring(0, loc);
        String dbffname = path + fname_withoutextention + ".dbf";
        String charsetName = dp.getProperty("charset");
        if (charsetName == null) {
            charsetName = Charset.defaultCharset().name();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.writeDbf(featureCollection, dbffname, Charset.forName(charsetName));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        GeometryCollection gc = this.makePersistentSHAPEGeometryCollection(featureCollection);
        if (Thread.interrupted() || gc == null) {
            throw new InterruptedException();
        }
        int shapeType = 2;
        if (dp.getProperty(SHAPE_TYPE_PROPERTY_KEY) != null) {
            String st = dp.getProperty(SHAPE_TYPE_PROPERTY_KEY);
            if (st.equalsIgnoreCase("xy")) {
                shapeType = 2;
            } else if (st.equalsIgnoreCase("xym")) {
                shapeType = 3;
            } else if (st.equalsIgnoreCase("xymz")) {
                shapeType = 4;
            } else if (st.equalsIgnoreCase("xyzm")) {
                shapeType = 4;
            } else {
                if (!st.equalsIgnoreCase("xyz")) throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.unknown-type"));
                shapeType = 4;
            }
        } else if (gc.getNumGeometries() > 0) {
            shapeType = this.guessCoordinateDims(gc.getGeometryN(0));
        }
        URL url = new URL("file", "localhost", shpfileName);
        Shapefile myshape = new Shapefile(url);
        myshape.write(gc, shapeType);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        String shxfname = path + fname_withoutextention + ".shx";
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(shxfname));
        EndianDataOutputStream sfile = new EndianDataOutputStream((OutputStream)in);
        myshape.writeIndex(gc, sfile, shapeType);
        if (!truncate) return;
        lastTimeTruncate = new Date().getTime();
    }

    public int guessCoordinateDims(Geometry g) {
        Coordinate[] cs = g.getCoordinates();
        for (int t = 0; t < cs.length; ++t) {
            if (Double.isNaN(cs[t].z)) continue;
            return 4;
        }
        return 2;
    }

    void writeDbf(FeatureCollection featureCollection, String fname) throws Exception {
        this.writeDbf(featureCollection, fname, Charset.defaultCharset());
    }

    void writeDbf(FeatureCollection featureCollection, String fname, Charset charset) throws Exception {
        int t;
        Map fieldMap = null;
        FeatureSchema fs = featureCollection.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount() - 1];
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        int f = 0;
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            nameToIndex.put(columnName, f);
            if (columnType == AttributeType.INTEGER) {
                if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.Numeric) {
                    WatergisDefaultRuleSet.Numeric type = (WatergisDefaultRuleSet.Numeric)this.getTypeFromRuleSet(columnName);
                    fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', type.getPrecision(), 0);
                } else if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.SubDataType) {
                    WatergisDefaultRuleSet.SubDataType cat = (WatergisDefaultRuleSet.SubDataType)((Object)this.getTypeFromRuleSet(columnName));
                    if (cat.getDataType() != null && cat.getDataType() instanceof WatergisDefaultRuleSet.Numeric) {
                        WatergisDefaultRuleSet.Numeric type = (WatergisDefaultRuleSet.Numeric)cat.getDataType();
                        fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', type.getPrecision(), 0);
                    } else {
                        fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', 11, 0);
                    }
                } else {
                    fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', 11, 0);
                }
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE) {
                if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.Numeric) {
                    WatergisDefaultRuleSet.Numeric type = (WatergisDefaultRuleSet.Numeric)this.getTypeFromRuleSet(columnName);
                    int lengthOfDecimalCharacter = (int)Math.signum((double)type.getScale());
                    fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', type.getPrecision() + lengthOfDecimalCharacter, type.getScale());
                } else if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.SubDataType) {
                    WatergisDefaultRuleSet.SubDataType cat = (WatergisDefaultRuleSet.SubDataType)((Object)this.getTypeFromRuleSet(columnName));
                    if (cat.getDataType() != null && cat.getDataType() instanceof WatergisDefaultRuleSet.Numeric) {
                        WatergisDefaultRuleSet.Numeric type = (WatergisDefaultRuleSet.Numeric)cat.getDataType();
                        int lengthOfDecimalCharacter = (int)Math.signum((double)type.getScale());
                        fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', type.getPrecision() + lengthOfDecimalCharacter, type.getScale());
                    } else {
                        fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', 33, 16);
                    }
                } else {
                    fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', 33, 16);
                }
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.OBJECT && (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.Numeric || this.getSubType(this.getTypeFromRuleSet(columnName)) instanceof WatergisDefaultRuleSet.Numeric)) {
                WatergisDefaultRuleSet.DataType type = this.getTypeFromRuleSet(columnName);
                WatergisDefaultRuleSet.Numeric numericType = null;
                numericType = type instanceof WatergisDefaultRuleSet.SubDataType ? (WatergisDefaultRuleSet.Numeric)this.getSubType(type) : (WatergisDefaultRuleSet.Numeric)type;
                int lengthOfDecimalCharacter = (int)Math.signum((double)numericType.getScale());
                fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', numericType.getPrecision() + lengthOfDecimalCharacter, numericType.getScale());
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.OBJECT && this.isBigDecimal(featureCollection, t)) {
                int[] places = this.determinePrecision(featureCollection, t);
                int precision = places[0];
                int scale = places[1];
                int lengthOfDecimalCharacter = (int)Math.signum((double)scale);
                fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', precision + lengthOfDecimalCharacter, scale);
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING && this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.Bool) {
                fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'N', 1, 0);
                fields[f] = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING) {
                int maxlength;
                if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.Varchar) {
                    WatergisDefaultRuleSet.Varchar type = (WatergisDefaultRuleSet.Varchar)this.getTypeFromRuleSet(columnName);
                    maxlength = type.getMaxLength();
                } else if (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.SubDataType) {
                    WatergisDefaultRuleSet.SubDataType cat = (WatergisDefaultRuleSet.SubDataType)((Object)this.getTypeFromRuleSet(columnName));
                    if (cat.getDataType() != null && cat.getDataType() instanceof WatergisDefaultRuleSet.Varchar) {
                        WatergisDefaultRuleSet.Varchar type = (WatergisDefaultRuleSet.Varchar)cat.getDataType();
                        maxlength = type.getMaxLength();
                    } else {
                        maxlength = this.findMaxStringLength(featureCollection, t);
                    }
                } else {
                    maxlength = this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.DateType ? 10 : (this.getTypeFromRuleSet(columnName) instanceof WatergisDefaultRuleSet.DateTime ? 26 : this.findMaxStringLength(featureCollection, t));
                }
                if (maxlength > 255) {
                    if (new Date().getTime() - lastTimeTruncate < 30000L) {
                        maxlength = 255;
                    } else {
                        OKCancelDialog okCancelDialog = this.getLongFieldManagementDialogBox();
                        okCancelDialog.setLocationRelativeTo(null);
                        okCancelDialog.setVisible(true);
                        if (okCancelDialog.wasOKPressed()) {
                            maxlength = 255;
                            truncate = true;
                        } else {
                            truncate = false;
                            throw new Exception(I18N.get((String)"io.ShapefileWriter.export-cancelled") + " " + I18N.get((String)"io.ShapefileWriter.more-than-255-characters-field-found"));
                        }
                    }
                }
                fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE) {
                fields[f] = new DbfFieldDef(columnName.toUpperCase(), 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.GEOMETRY) continue;
            throw new Exception(I18N.get((String)"io.ShapefileWriter.unsupported-attribute-type"));
        }
        DbfFileWriter dbf = new DbfFileWriter(fname);
        dbf.setCharset(charset);
        dbf.writeHeader(fields, featureCollection.size());
        int num = featureCollection.size();
        List features = featureCollection.getFeatures();
        for (t = 0; t < num; ++t) {
            Feature feature = (Feature)features.get(t);
            Vector<Object> DBFrow = new Vector<Object>();
            for (int u = 0; u < fs.getAttributeCount(); ++u) {
                Object a;
                AttributeType columnType = fs.getAttributeType(u);
                String name = fs.getAttributeName(u);
                if (columnType == AttributeType.INTEGER) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(null);
                        continue;
                    }
                    if (a instanceof Integer) {
                        DBFrow.add((Integer)a);
                        continue;
                    }
                    if (!(a instanceof Long)) continue;
                    DBFrow.add((Long)a);
                    continue;
                }
                if (columnType == AttributeType.DOUBLE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(null);
                        continue;
                    }
                    int index = (Integer)nameToIndex.get(name);
                    if (fields[index].fieldnumdec > 0) {
                        BigDecimal bd = new BigDecimal((Double)a);
                        Double d = bd.setScale(fields[index].fieldnumdec, RoundingMode.HALF_UP).doubleValue();
                        DBFrow.add(d);
                        continue;
                    }
                    long val = Math.round((Double)a);
                    DBFrow.add(val);
                    continue;
                }
                if (columnType == AttributeType.DATE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add("");
                        continue;
                    }
                    DBFrow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType == AttributeType.OBJECT) {
                    a = feature.getAttribute(u);
                    if (a instanceof BigDecimal) {
                        DBFrow.add(((BigDecimal)a).doubleValue());
                        continue;
                    }
                    DBFrow.add(null);
                    continue;
                }
                if (columnType == AttributeType.STRING && this.getTypeFromRuleSet(name) instanceof WatergisDefaultRuleSet.Bool) {
                    a = feature.getAttribute(u);
                    if (a instanceof Boolean) {
                        if (((Boolean)a).booleanValue()) {
                            DBFrow.add(1);
                            continue;
                        }
                        DBFrow.add(0);
                        continue;
                    }
                    if (a instanceof String) {
                        if (String.valueOf(a).equalsIgnoreCase("true")) {
                            DBFrow.add(1);
                            continue;
                        }
                        DBFrow.add(0);
                        continue;
                    }
                    DBFrow.add(null);
                    continue;
                }
                if (columnType != AttributeType.STRING) continue;
                a = feature.getAttribute(u);
                if (a == null) {
                    DBFrow.add(new String(""));
                    continue;
                }
                if (a instanceof String) {
                    DBFrow.add(a);
                    continue;
                }
                DBFrow.add(a.toString());
            }
            dbf.writeRecord(DBFrow);
        }
        dbf.close();
    }

    private boolean isBigDecimal(FeatureCollection featureCollection, int index) {
        for (Object o : featureCollection.getFeatures()) {
            if (o instanceof Feature) {
                Feature f = (Feature)o;
                Object attr = f.getAttribute(index);
                if (attr == null || attr instanceof BigDecimal) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private int[] determinePrecision(FeatureCollection featureCollection, int index) {
        int p = 1;
        int s = 0;
        for (Object o : featureCollection.getFeatures()) {
            Feature f;
            Object attr;
            if (!(o instanceof Feature) || !((attr = (f = (Feature)o).getAttribute(index)) instanceof BigDecimal)) continue;
            if (((BigDecimal)attr).precision() > p) {
                p = ((BigDecimal)attr).precision();
            }
            if (((BigDecimal)attr).scale() <= s) continue;
            s = ((BigDecimal)attr).scale();
        }
        return new int[]{p, s};
    }

    private WatergisDefaultRuleSet.DataType getTypeFromRuleSet(String columnName) {
        return this.ruleSet == null ? null : this.ruleSet.getType(this.coalesce(this.aliasNameToNameMap.get(columnName), columnName));
    }

    private String coalesce(String arg, String defaultValue) {
        return arg == null ? defaultValue : arg;
    }

    private WatergisDefaultRuleSet.DataType getSubType(WatergisDefaultRuleSet.DataType type) {
        if (type instanceof WatergisDefaultRuleSet.SubDataType) {
            return ((WatergisDefaultRuleSet.SubDataType)((Object)type)).getDataType();
        }
        return null;
    }

    private DbfFieldDef overrideWithExistingCompatibleDbfFieldDef(DbfFieldDef field, Map columnMap) {
        String fieldname = field.fieldname.toString().trim();
        if (columnMap != null && columnMap.containsKey(fieldname)) {
            DbfFieldDef dbfFieldDef = (DbfFieldDef)columnMap.get(fieldname);
            dbfFieldDef.fieldname = field.fieldname;
            switch (dbfFieldDef.fieldtype) {
                case 'C': 
                case 'c': {
                    if (field.fieldtype != 'C') break;
                    if (field.fieldlen > dbfFieldDef.fieldlen) {
                        return field;
                    }
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    if (field.fieldtype != 'N') break;
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
            }
        }
        return field;
    }

    int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        int maxlen = 0;
        for (Feature f : fc) {
            int l;
            if (f.getString(attributeNumber) == null || (l = f.getString(attributeNumber).getBytes().length) <= maxlen) continue;
            maxlen = l;
        }
        return Math.max(1, maxlen);
    }

    int findBestGeometryType(FeatureCollection fc) {
        boolean onlyPoints = true;
        boolean onlyEmptyGeometryCollection = true;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Geometry geom = ((Feature)i.next()).getGeometry();
            if (onlyPoints && !(geom instanceof Point)) {
                onlyPoints = false;
            }
            if (onlyEmptyGeometryCollection && !geom.isEmpty()) {
                onlyEmptyGeometryCollection = false;
            }
            if (geom instanceof MultiPoint) {
                return 8;
            }
            if (geom instanceof Polygon) {
                return 5;
            }
            if (geom instanceof MultiPolygon) {
                return 5;
            }
            if (geom instanceof LineString) {
                return 3;
            }
            if (!(geom instanceof MultiLineString)) continue;
            return 3;
        }
        if (onlyPoints) {
            return 1;
        }
        if (onlyEmptyGeometryCollection) {
            return 0;
        }
        return 31;
    }

    public void checkIfGeomsAreMixed(FeatureCollection featureCollection) throws IllegalParametersException, Exception {
        int i = 0;
        Class<?> firstClass = null;
        Geometry firstGeom = null;
        for (Feature myf : featureCollection) {
            if (i == 0) {
                firstClass = myf.getGeometry().getClass();
                firstGeom = myf.getGeometry();
            } else if (!(firstClass == myf.getGeometry().getClass() || firstGeom instanceof Polygon && myf.getGeometry() instanceof MultiPolygon || firstGeom instanceof MultiPolygon && myf.getGeometry() instanceof Polygon || firstGeom instanceof Point && myf.getGeometry() instanceof MultiPoint || firstGeom instanceof MultiPoint && myf.getGeometry() instanceof Point || firstGeom instanceof LineString && myf.getGeometry() instanceof MultiLineString || firstGeom instanceof MultiLineString && myf.getGeometry() instanceof LineString)) {
                throw new IllegalParametersException(I18N.get((String)"io.ShapefileWriter.unsupported-mixed-geometry-type"));
            }
            ++i;
        }
    }

    LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return new LinearRing(newCoords, new PrecisionModel(), 0);
    }

    Polygon makeGoodSHAPEPolygon(Polygon p) {
        if (p.isEmpty()) {
            return p;
        }
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
        }
        return new Polygon(outer, holes, new PrecisionModel(), 0);
    }

    MultiPolygon makeGoodSHAPEMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            ps[t] = this.makeGoodSHAPEPolygon((Polygon)mp.getGeometryN(t));
        }
        MultiPolygon result = new MultiPolygon(ps, new PrecisionModel(), 0);
        return result;
    }

    public GeometryCollection makeSHAPEGeometryCollection(FeatureCollection fc) throws Exception {
        Geometry[] allGeoms = new Geometry[fc.size()];
        int geomtype = this.findBestGeometryType(fc);
        if (geomtype == 31) {
            throw new Exception(I18N.get((String)"io.ShapefileWriter.unsupported-geometry-collection"));
        }
        List features = fc.getFeatures();
        block7: for (int t = 0; t < features.size(); ++t) {
            Geometry geom = ((Feature)features.get(t)).getGeometry();
            switch (geomtype) {
                case 0: {
                    allGeoms[t] = geom.getFactory().createGeometryCollection(new Geometry[0]);
                    continue block7;
                }
                case 1: {
                    if (geom instanceof Point) {
                        allGeoms[t] = (Point)geom;
                        continue block7;
                    }
                    allGeoms[t] = new Point(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 8: {
                    Point[] p;
                    if (geom instanceof Point) {
                        p = new Point[]{(Point)geom};
                        allGeoms[t] = new MultiPoint(p, new PrecisionModel(), 0);
                        continue block7;
                    }
                    if (geom instanceof MultiPoint) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = new MultiPoint(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 3: {
                    if (geom instanceof LineString) {
                        LineString[] l = new LineString[]{(LineString)geom};
                        allGeoms[t] = new MultiLineString(l, new PrecisionModel(), 0);
                        continue block7;
                    }
                    if (geom instanceof MultiLineString) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = new MultiLineString(null, new PrecisionModel(), 0);
                    continue block7;
                }
                case 5: {
                    Point[] p;
                    if (geom instanceof Polygon) {
                        p = new Polygon[]{(Polygon)geom};
                        allGeoms[t] = this.makeGoodSHAPEMultiPolygon(new MultiPolygon((Polygon[])p, new PrecisionModel(), 0));
                        continue block7;
                    }
                    allGeoms[t] = geom instanceof MultiPolygon ? this.makeGoodSHAPEMultiPolygon((MultiPolygon)geom) : new MultiPolygon(null, new PrecisionModel(), 0);
                }
            }
        }
        GeometryCollection result = new GeometryCollection(allGeoms, new PrecisionModel(), 0);
        return result;
    }

    public GeometryCollection makePersistentSHAPEGeometryCollection(FeatureCollection fc) throws Exception {
        PersistentGeometryWrapper[] allGeoms = new PersistentGeometryWrapper[fc.size()];
        int geomtype = this.findBestGeometryType(fc);
        if (geomtype == 31) {
            throw new Exception(I18N.get((String)"io.ShapefileWriter.unsupported-geometry-collection"));
        }
        List features = fc.getFeatures();
        FilePersistenceManager pm = ((JumpFeature)features.get(0)).getPersistenceManager();
        block7: for (int t = 0; t < features.size(); ++t) {
            if (Thread.interrupted()) {
                return null;
            }
            Geometry geom = ((Feature)features.get(t)).getGeometry();
            switch (geomtype) {
                case 0: {
                    allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)geom.getFactory().createGeometryCollection(new Geometry[0]), pm);
                    continue block7;
                }
                case 1: {
                    if (geom instanceof Point) {
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Feature)features.get(t));
                        continue block7;
                    }
                    allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new Point(null, new PrecisionModel(), 0), pm);
                    continue block7;
                }
                case 8: {
                    Point[] p;
                    if (geom instanceof Point) {
                        p = new Point[]{(Point)geom};
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new MultiPoint(p, new PrecisionModel(), 0), pm);
                        continue block7;
                    }
                    if (geom instanceof MultiPoint) {
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Feature)features.get(t));
                        continue block7;
                    }
                    allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new MultiPoint(null, new PrecisionModel(), 0), pm);
                    continue block7;
                }
                case 3: {
                    if (geom instanceof LineString) {
                        LineString[] l = new LineString[]{(LineString)geom};
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new MultiLineString(l, new PrecisionModel(), 0), pm);
                        continue block7;
                    }
                    if (geom instanceof MultiLineString) {
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Feature)features.get(t));
                        continue block7;
                    }
                    allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new MultiLineString(null, new PrecisionModel(), 0), pm);
                    continue block7;
                }
                case 5: {
                    Point[] p;
                    if (geom instanceof Polygon) {
                        p = new Polygon[]{(Polygon)geom};
                        MultiPolygon validGeom = this.makeGoodSHAPEMultiPolygon(new MultiPolygon((Polygon[])p, new PrecisionModel(), 0));
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)validGeom, pm);
                        continue block7;
                    }
                    if (geom instanceof MultiPolygon) {
                        MultiPolygon validGeom = this.makeGoodSHAPEMultiPolygon((MultiPolygon)geom);
                        if (validGeom.equalsExact(geom)) {
                            allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Feature)features.get(t));
                            continue block7;
                        }
                        allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)validGeom, pm);
                        continue block7;
                    }
                    allGeoms[t] = new PersistentGeometryWrapper(geom.getFactory(), (Geometry)new MultiPolygon(null, new PrecisionModel(), 0), pm);
                }
            }
        }
        GeometryCollectionWrapper result = new GeometryCollectionWrapper(allGeoms, new PrecisionModel(), 0);
        return result;
    }

    private OKCancelDialog getLongFieldManagementDialogBox() {
        return new OKCancelDialog((Frame)null, I18N.get((String)"io.ShapefileWriter.fields-too-long"), true, (Component)new JLabel("<html><br/>" + I18N.get((String)"io.ShapefileWriter.more-than-255-characters-field-found") + "<br/><br/>" + I18N.get((String)"io.ShapefileWriter.truncate-option") + "<br/></html>"), null);
    }
}

