/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.creator.GeometryFinishedListener;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class SplitGeometryListener
extends CreateNewGeometryListener {
    public static final String LISTENER_KEY = "SplitGeometryListener";
    private GeometryFinishedListener geometryFinishedListener;

    public SplitGeometryListener(MappingComponent mc, GeometryFinishedListener geometryFinishedListener) {
        super(mc);
        this.geometryFinishedListener = geometryFinishedListener;
        this.setMode("LINESTRING");
    }

    protected void finishGeometry(AbstractNewFeature newFeature) {
        this.mappingComponent.getTmpFeatureLayer().removeAllChildren();
        this.geometryFinishedListener.geometryFinished(newFeature.getGeometry());
    }

    protected PPath createNewTempFeature() {
        PPath newTempFeaturePath = new PPath();
        newTempFeaturePath.setStroke((Stroke)new FixedWidthStroke());
        if (!this.isInMode("LINESTRING")) {
            Color fillingColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
            newTempFeaturePath.setStrokePaint((Paint)fillingColor.darker());
            newTempFeaturePath.setPaint((Paint)fillingColor);
        } else {
            Color fillingColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
            newTempFeaturePath.setStroke((Stroke)new CustomFixedWidthStroke(3.0f));
            newTempFeaturePath.setStrokePaint((Paint)fillingColor);
        }
        return newTempFeaturePath;
    }
}

