/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;

import org.openide.util.lookup.ServiceProvider;

import java.sql.Connection;
import java.sql.Statement;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = CidsTrigger.class)
public class FgBakWkTrigger extends AbstractDBAwareCidsTrigger {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            FgBakWkTrigger.class);
    private static final String FG_BAK_WK_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_bak_wk";
    private static final String FG_BAK_WK_TABLE_NAME = "dlm25w.fg_bak_wk";
    private static final ThreadPoolExecutor SINGLE_THREAD_EXECUTOR = new ThreadPoolExecutor(
            1,
            1,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<Runnable>());

    //~ Methods ----------------------------------------------------------------

    @Override
    public void afterDelete(final CidsBean cidsBean, final User user) {
    }

    @Override
    public void afterInsert(final CidsBean cidsBean, final User user) {
    }

    @Override
    public void afterUpdate(final CidsBean cidsBean, final User user) {
    }

    @Override
    public void beforeDelete(final CidsBean cidsBean, final User user) {
    }

    @Override
    public void beforeInsert(final CidsBean cidsBean, final User user) {
    }

    @Override
    public void beforeUpdate(final CidsBean cidsBean, final User user) {
    }

    @Override
    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey(CidsTriggerKey.ALL, FG_BAK_WK_TABLE_NAME);
    }

    /**
     * DOCUMENT ME!
     *
     * @param   o  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public int compareTo(final CidsTrigger o) {
        return 0;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   cidsBean  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private boolean isFgBakWkObject(final CidsBean cidsBean) {
        return (cidsBean.getClass().getName().equals(FG_BAK_WK_CLASS_NAME));
    }

    @Override
    public void afterCommittedInsert(final CidsBean cidsBean, final User user) {
        restat(cidsBean, user);
    }

    @Override
    public void afterCommittedUpdate(final CidsBean cidsBean, final User user) {
        restat(cidsBean, user);
    }

    @Override
    public void afterCommittedDelete(final CidsBean cidsBean, final User user) {
        restat(cidsBean, user);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean  DOCUMENT ME!
     * @param  user      DOCUMENT ME!
     */
    private void restat(final CidsBean cidsBean, final User user) {
        if (isFgBakWkObject(cidsBean)) {
            Connection con = null;
            try {
                final long start = System.currentTimeMillis();
                final Integer wkNr = (Integer)cidsBean.getProperty("wk_nr.id");

                if (wkNr != null) {
                    con = getDbServer().getConnectionPool().getConnection(true);
                    final Statement s = con.createStatement();
                    s.execute("select dlm25w.update_fg_lak_wk(" + String.valueOf(wkNr) + ")");
                    s.execute("select dlm25w.update_k_wk_fg_wk_ordnung()");
                    LOG.error("time to update stations " + (System.currentTimeMillis() - start));
                }
            } catch (Exception e) {
                LOG.error("Error while executing fgBakWk trigger.", e);
            } finally {
                if (con != null) {
                    getDbServer().getConnectionPool().releaseDbConnection(con);
                }
            }

            if (SINGLE_THREAD_EXECUTOR.getPoolSize() < 2) {
                final Runnable r = new Runnable() {

                        @Override
                        public void run() {
                            Connection con = null;

                            try {
                                con = getDbServer().getConnectionPool().getConnection(true);
                                final Statement s = con.createStatement();
                                s.execute(
                                    "select dlm25w.migrate_fg_bak_wk_to_fg_lak()");
                            } catch (Exception e) {
                                LOG.error(
                                    "Error while executing async fg_lak_wk trigger.",
                                    e);
                            } finally {
                                if (con != null) {
                                    getDbServer().getConnectionPool().releaseDbConnection(con);
                                }
                            }
                        }
                    };

                SINGLE_THREAD_EXECUTOR.execute(r);
            }
        }
    }
}
