/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AddProfileAction
implements ServerAction,
MetaServiceStore,
UserAwareServerAction {
    private static final Logger LOG = Logger.getLogger(AddProfileAction.class);
    private static final String INSERT_PKT = "INSERT INTO dlm25w.qp_pkte (qp_upl,qp_npl,gaf_id,stat,y,z,kz,rk,bk,hw,rw,hyk,fis_g_user, fis_g_date, geom) values (?,?,?,?,?,?,?,?,?,?,?,?,?, now(), st_point(?,?))";
    public static final String TASK_NAME = "addProfileAction";
    private User user;
    private MetaService metaService;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Statement psCreate;
        Connection con;
        DomainServerImpl domainServer;
        block16: {
            domainServer = null;
            con = null;
            psCreate = null;
            try {
                Object[][] data = null;
                for (ServerActionParameter param : params) {
                    if (!ParameterType.DATA.toString().equals(param.getKey())) continue;
                    data = (Object[][])param.getValue();
                }
                domainServer = (DomainServerImpl)this.metaService;
                con = domainServer.getConnectionPool().getLongTermConnection();
                Statement st = con.createStatement();
                PreparedStatement pst = con.prepareStatement(INSERT_PKT);
                if (data != null) {
                    for (Object[] o : data) {
                        Double rk = (Double)o[7];
                        Double bk = (Double)o[8];
                        pst.setObject(1, (Integer)o[0]);
                        pst.setObject(2, (Integer)o[1]);
                        pst.setString(3, (String)o[2]);
                        pst.setObject(4, (Double)o[3]);
                        pst.setObject(5, (Double)o[4]);
                        pst.setObject(6, (Double)o[5]);
                        pst.setString(7, (String)o[6]);
                        pst.setObject(8, rk != null ? Integer.valueOf(rk.intValue()) : null);
                        pst.setObject(9, bk != null ? Integer.valueOf(bk.intValue()) : null);
                        pst.setObject(10, (Double)o[9]);
                        pst.setObject(11, (Double)o[10]);
                        pst.setString(12, (String)o[11]);
                        pst.setString(13, this.user.getName());
                        pst.setObject(14, (Double)o[10]);
                        pst.setObject(15, (Double)o[9]);
                        pst.addBatch();
                    }
                    pst.executeBatch();
                    pst.close();
                }
                bl = true;
                if (psCreate == null) break block16;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while inserting qp_pkte objects", (Throwable)e);
                Boolean bl2 = false;
                return bl2;
            }
            try {
                psCreate.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (domainServer == null) return bl;
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (psCreate != null) {
                try {
                    psCreate.close();
                }
                catch (SQLException sQLException) {}
            }
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        DATA;

    }
}

