/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RemoveSchemaAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(RemoveSchemaAction.class);
    private static final String REMOVE_SCHEMA = "DROP SCHEMA %1s cascade";
    public static final String TASK_NAME = "removeSchema";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Connection con;
        DomainServerImpl domainServer;
        block10: {
            Boolean bl2;
            block9: {
                domainServer = null;
                con = null;
                try {
                    String schemaName = null;
                    for (ServerActionParameter param : params) {
                        if (!ParameterType.SCHEMA.toString().equals(param.getKey())) continue;
                        schemaName = (String)param.getValue();
                    }
                    if (ActionHelper.isInvalidSchemaName(schemaName)) {
                        bl2 = false;
                        if (domainServer == null) return bl2;
                        if (con == null) return bl2;
                        break block9;
                    }
                    domainServer = (DomainServerImpl)this.metaService;
                    con = domainServer.getConnectionPool().getLongTermConnection();
                    String string = ActionHelper.quoteIdentifier(con, schemaName);
                    Statement st = con.createStatement();
                    st.executeUpdate(String.format(REMOVE_SCHEMA, string));
                    st.close();
                    bl = true;
                    if (domainServer == null) return bl;
                    break block10;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating schema", (Throwable)e);
                    Boolean bl3 = false;
                    return bl3;
                }
            }
            domainServer.getConnectionPool().releaseDbConnection(con);
            return bl2;
        }
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        SCHEMA;

    }
}

