/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class UserExistsAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(UserExistsAction.class);
    private static final String USER_EXISTS = "SELECT 1 FROM pg_roles WHERE rolname= ?";
    public static final String TASK_NAME = "userExists";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        boolean userExists = false;
        DomainServerImpl domainServer = null;
        Connection con = null;
        try {
            String userName = null;
            for (ServerActionParameter param : params) {
                if (!ParameterType.DB_USER.toString().equals(param.getKey())) continue;
                userName = (String)param.getValue();
            }
            if (ActionHelper.isInvalidSchemaName(userName)) {
                return false;
            }
            domainServer = (DomainServerImpl)this.metaService;
            con = domainServer.getConnectionPool().getConnection();
            PreparedStatement psCreate = con.prepareStatement(USER_EXISTS);
            psCreate.setString(1, userName);
            boolean res = psCreate.execute();
            if (res) {
                ResultSet rs = psCreate.getResultSet();
                if (rs != null && rs.next()) {
                    userExists = true;
                }
                if (rs != null) {
                    rs.close();
                }
            }
            psCreate.close();
            return userExists;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking, if the given user already exists", (Throwable)e);
            return userExists;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        DB_USER;

    }
}

