/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class AbstractAnalyzeSearch
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AbstractAnalyzeSearch.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private final String dbQuery;

    public AbstractAnalyzeSearch(String owner, int[] ids, boolean export) {
        this.dbQuery = this.createQuery(owner, ids, export);
    }

    protected abstract String createQuery(String var1, int[] var2, boolean var3);

    protected String createSqlString(int[] ids) {
        return SQLFormatter.createSqlArrayString(ids);
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = String.format(this.dbQuery, new Object[0]);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

