/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class AllGemeinden
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllGemeinden.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "Select \nid\nfrom dlm25w.vw_alk_gmd";
    private static final String QUERY_WITH_ID = "Select g.gmd_nr from dlm25w.vw_alk_gmd g join geom gg on (g.geom = gg.id) \nwhere exists(select 1 from dlm25w.fg_ba ba join geom ge on (geom = ge.id) where ba.id = any (%1$s)\n and st_intersects(gg.geo_field, ge.geo_field))";
    private List<Integer> baIdList;

    public AllGemeinden() {
        this(null);
    }

    public AllGemeinden(List<Integer> baIdList) {
        this.baIdList = baIdList;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                if (this.baIdList != null && !this.baIdList.isEmpty()) {
                    int[] ids = new int[this.baIdList.size()];
                    for (int i = 0; i < this.baIdList.size(); ++i) {
                        ids[i] = this.baIdList.get(i);
                    }
                    ArrayList lists = ms.performCustomSearch(String.format(QUERY_WITH_ID, SQLFormatter.createSqlArrayString(ids)));
                    return lists;
                }
                ArrayList lists = ms.performCustomSearch(QUERY);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

