/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AllGewGeschlByGeom
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AllGewGeschlByGeom.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select id, owner, gu, wdm, gew_name, tf, dim, art, ba_cd, ba_st_von, ba_st_bis, nr_re, nr_li, ls, prof, ma, objNr, tr, ausbaujahr, wbbl, code, zustKl, br, brOben, hoehe, hEin, hAus, gefaelle, dhAus, dhEin, hAb, hAuf, aufstieg, trGu, objNrGu from dlm25w.select_geom_geschl(%1$s, %2$s, '%3$s')";
    private final int[] routeIds;
    private final int[] wdmArray;
    private final Geometry geom;

    public AllGewGeschlByGeom(int[] routeIds, int[] wdmArray, Geometry geom) {
        this.geom = geom;
        this.routeIds = routeIds;
        this.wdmArray = wdmArray;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = String.format(QUERY, SQLFormatter.createSqlArrayString(this.routeIds), SQLFormatter.createSqlArrayString(this.wdmArray), this.geom);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

