/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class CheckForCreatedObjectTable
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(CheckForCreatedObjectTable.class);
    private static final String QUERY = "select co.class_id, co.object_id from created_object co, lock_group lg join lock_lock_group llg on (lg.objects = llg.lock_group_reference) join lock l on (llg.lock = l.id) where l.object_id = co.object_id and l.class_id = co.class_id and username = ? and additional_info = ?";
    public static final String DOMAIN_NAME = "DLM25W";
    private final String user;
    private final String cname;

    public CheckForCreatedObjectTable(String user, String cname) {
        this.user = user;
        this.cname = cname;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps = new PreparableStatement(QUERY, new int[]{12, 12});
                ps.setObjects(new Object[]{this.user, this.cname});
                return ms.performCustomSearch(ps);
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

