/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class FgBaCdCheck
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(FgBaCdCheck.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_CONDITION = "(id <> %s and ba_cd = '%s')";
    private static final String QUERY = "select ba_cd from dlm25w.fg_bak bak ";
    private final Map<Integer, String> baCdMap;

    public FgBaCdCheck(Map<Integer, String> baCdMap) {
        this.baCdMap = baCdMap;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                boolean first = true;
                String query = QUERY;
                for (Integer id : this.baCdMap.keySet()) {
                    String baCd = this.baCdMap.get(id);
                    if (first) {
                        query = query + " WHERE ";
                        first = false;
                    } else {
                        query = query + " OR ";
                    }
                    query = query + String.format(QUERY_CONDITION, id, baCd);
                }
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

