/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class FgBakCount
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(FgBakCount.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_WITHOUT_OWNER = "select count(*) from dlm25w.fg_bak bak join dlm25w.fg_ba ba on (ba.bak_id = bak.id) where (%1$s is null or ba.id = any(%1$s))";
    private static final String QUERY = "select count(*) from dlm25w.fg_bak bak join dlm25w.fg_ba ba on (ba.bak_id = bak.id)  left join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr) where (%2$s is null or ba.id = any(%2$s)) and gr.owner = '%1$s'";
    private static final String QUERY_BAK_WITHOUT_OWNER = "select count(*) from dlm25w.fg_bak bak where (%1$s is null or bak.id = any(%1$s))";
    private static final String QUERY_BAK = "select count(*) from dlm25w.fg_bak bak  left join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr) where (%2$s is null or bak.id = any(%2$s)) and gr.owner = '%1$s'";
    private final String owner;
    private final int[] baIds;
    private final int[] bakIds;

    public FgBakCount(String owner, int[] baIds, int[] bakIds) {
        this.owner = owner;
        this.baIds = baIds;
        this.bakIds = bakIds;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = null;
                query = this.baIds != null ? (this.owner == null ? String.format(QUERY_WITHOUT_OWNER, SQLFormatter.createSqlArrayString(this.baIds)) : String.format(QUERY, this.owner, SQLFormatter.createSqlArrayString(this.baIds))) : (this.owner == null ? String.format(QUERY_BAK_WITHOUT_OWNER, SQLFormatter.createSqlArrayString(this.bakIds)) : String.format(QUERY_BAK, this.owner, SQLFormatter.createSqlArrayString(this.bakIds)));
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

