/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class GafPosition
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(GafPosition.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select st_asbinary(st_intersection(geo_field, st_setSrid('%1$s'::geometry, 5650)))\nfrom\ndlm25w.fg_ba\njoin geom on (geom = geom.id)\nwhere st_intersects(geo_field, st_setSrid('%1$s'::geometry, 5650) limit %2$s";
    private final Geometry geom;
    private int limit;

    public GafPosition(Geometry geom, int limit) {
        this.geom = geom;
        this.limit = limit;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.geom.toText(), this.limit));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

