/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.custom.watergis.server.search.WritableSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MergeSearch
extends WritableSearch
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(MergeSearch.class);
    public static final String DOMAIN_NAME = "DLM25W";
    protected String QUERY;
    protected String owner;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public MergeSearch(String owner) {
        this.owner = owner;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps = new PreparableStatement(this.QUERY, new int[]{12});
                ps.setObjects(new Object[]{this.owner});
                ArrayList lists = ms.performCustomSearch(ps, this.connectionContext);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.connectionContext = this.connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

