/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ObjectEnvelopes
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(ObjectEnvelopes.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_KREIS = "Select \nst_asBinary(st_envelope(geom.geo_field)) as geom,\ndlm25w.vw_dvg_kreis.kreis_name, dlm25w.vw_dvg_kreis.id \nfrom dlm25w.vw_dvg_kreis \njoin geom on (geom = geom.id) \n";
    private static final String QUERY_AMT = "Select \nst_asBinary(st_envelope(geom.geo_field)) as geom,\ndlm25w.vw_dvg_amt.amt_name, dlm25w.vw_dvg_amt.id \nfrom dlm25w.vw_dvg_amt \njoin geom on (geom = geom.id) \n";
    private static final String QUERY_WBV = "Select \nst_asBinary(st_envelope(geom.geo_field)) as geom,\ndlm25w.ezg_mv_wbv.name, dlm25w.ezg_mv_wbv.id \nfrom dlm25w.ezg_mv_wbv \njoin geom on (geom = geom.id) \n";
    private final ObjectType type;

    public ObjectEnvelopes(ObjectType type) {
        this.type = type;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = this.type.equals((Object)ObjectType.KREIS) ? QUERY_KREIS : (this.type.equals((Object)ObjectType.AMT) ? QUERY_AMT : QUERY_WBV);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public static enum ObjectType {
        AMT,
        KREIS,
        WBV;

    }
}

