/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PreparedRandstreifenGeoms
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(PreparedRandstreifenGeoms.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "Select st_asBinary(dlm25w.buffer_randstreifen(ST_Collect(ST_SnapToGrid(geo_field, 0.01)), 0.01)) from (%1s) a";
    private static final String FG_QUERY = "select geo_field from dlm25w.fg_ba_gerog join geom on (geom = geom.id) where typ in ('so', 'b_li', 'b_re', 'bn_li', 'bn_re', 'bt_li', 'bt_re')  and st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650))";
    private static final String FG_QUERY_WITH_ID = "select geo_field from dlm25w.fg_ba_gerog join geom on (geom = geom.id) where typ in ('so', 'b_li', 'b_re', 'bn_li', 'bn_re', 'bt_li', 'bt_re')  and st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650)) and ba_cd in (%2s)";
    private static final String FG_CLOSED_QUERY = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_closed(null, null)";
    private static final String FG_CLOSED_QUERY_WITH_ID = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_closed(%2s, null)";
    private static final String FG_BR_QUERY = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_open_without_prof(null, null, '%1s') where art = 'o'";
    private static final String FG_BR_QUERY_WITH_ID = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_open_without_prof(%2s, null, '%3s') where art = 'o'";
    private static final String FG_FL_QUERY = "select geo_field from dlm25w.fg_ba_fl join geom on (geom = geom.id) where st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650))";
    private static final String SEE_QUERY = "select geo_field from dlm25w.sg_see join geom on (geom = geom.id) where st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650))";
    private static final String SEE_KL_QUERY = "select geo_field from dlm25w.sg_see_kl join geom on (geom = geom.id) where st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650))";
    private static final String OSTSEE_QUERY = "select dlm25w.withoutHoles(geo_field) as geo_field from dlm25w.ezg_mv_ostsee join geom on (geom = geom.id) where st_intersects(geo_field, st_setSrid('%1s'::geometry, 5650))";
    private static final String FG_QUERY_WITHOUT_GEO = "select geo_field from dlm25w.fg_ba_gerog join geom on (geom = geom.id) where typ in ('so', 'b_li', 'b_re', 'bn_li', 'bn_re', 'bt_li', 'bt_re')";
    private static final String FG_QUERY_WITHOUT_GEO_WITH_ID = "select geo_field from dlm25w.fg_ba_gerog join geom on (geom = geom.id) where typ in ('so', 'b_li', 'b_re', 'bn_li', 'bn_re', 'bt_li', 'bt_re') and ba_cd in (%1s)";
    private static final String FG_BR_QUERY_WITHOUT_GEO = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_open_without_prof(null, null) where art = 'o'";
    private static final String FG_BR_QUERY_WITHOUT_GEO_WITH_ID = "select dlm25w.buffer_randstreifen(geom, %1s) as geo_field from dlm25w.select_fgba_open_without_prof(%2s, null) where art = 'o'";
    private static final String FG_FL_QUERY_WITHOUT_GEO = "select geo_field from dlm25w.fg_ba_fl join geom on (geom = geom.id)";
    private static final String SEE_QUERY_WITHOUT_GEO = "select geo_field from dlm25w.sg_see join geom on (geom = geom.id)";
    private static final String SEE_KL_QUERY_WITHOUT_GEO = "select geo_field from dlm25w.sg_see_kl join geom on (geom = geom.id)";
    private static final String OSTSEE_QUERY_WITHOUT_GEO = "select dlm25w.withoutHoles(geo_field) as geo_field from dlm25w.ezg_mv_ostsee join geom on (geom = geom.id)";
    private final Geometry bbox;
    private final boolean fg;
    private final boolean fgBr;
    private final boolean geschlFg;
    private final double br;
    private final double geschlBr;
    private final boolean fgFl;
    private final boolean see;
    private final boolean seeKl;
    private final boolean ostsee;
    private final String[] baCd;
    private final Integer[] fgBaIdBr;

    public PreparedRandstreifenGeoms(Geometry bbox, boolean fg, boolean fgBr, boolean geschlFg, boolean fgFl, boolean see, boolean seeKl, boolean ostsee, double br, double geschlBr, String[] baCd, Integer[] fgBaIdBr) {
        this.bbox = bbox;
        this.fg = fg;
        this.fgBr = fgBr;
        this.geschlFg = geschlFg;
        this.fgFl = fgFl;
        this.see = see;
        this.seeKl = seeKl;
        this.ostsee = ostsee;
        this.br = br;
        this.geschlBr = geschlBr;
        this.baCd = baCd;
        this.fgBaIdBr = fgBaIdBr;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String tables = null;
                if (this.fg) {
                    tables = this.baCd == null ? String.format(this.bbox == null ? FG_QUERY_WITHOUT_GEO : FG_QUERY, this.bbox) : (this.bbox == null ? String.format(FG_QUERY_WITHOUT_GEO_WITH_ID, this.toList(this.baCd)) : String.format(FG_QUERY_WITH_ID, this.bbox, this.toList(this.baCd)));
                }
                if (this.fgBr) {
                    tables = this.fgBaIdBr == null ? (tables == null ? (this.bbox == null ? String.format(FG_BR_QUERY_WITHOUT_GEO, this.br) : String.format(FG_BR_QUERY, this.br, this.bbox)) : (this.bbox == null ? tables + " union " + String.format(FG_BR_QUERY_WITHOUT_GEO, this.br) : tables + " union " + String.format(FG_BR_QUERY, this.br, this.bbox))) : (tables == null ? (this.bbox == null ? String.format(FG_BR_QUERY_WITHOUT_GEO_WITH_ID, this.br, this.toArrayString(this.fgBaIdBr)) : String.format(FG_BR_QUERY_WITH_ID, this.br, this.toArrayString(this.fgBaIdBr), this.bbox)) : (this.bbox == null ? tables + " union " + String.format(FG_BR_QUERY_WITHOUT_GEO_WITH_ID, this.br, this.toArrayString(this.fgBaIdBr)) : tables + " union " + String.format(FG_BR_QUERY_WITH_ID, this.br, this.toArrayString(this.fgBaIdBr), this.bbox)));
                }
                if (this.fgFl) {
                    tables = tables == null ? String.format(this.bbox == null ? FG_FL_QUERY_WITHOUT_GEO : FG_FL_QUERY, this.bbox) : tables + " union " + String.format(this.bbox == null ? FG_FL_QUERY_WITHOUT_GEO : FG_FL_QUERY, this.bbox);
                }
                if (this.geschlFg) {
                    tables = tables == null ? String.format(this.baCd == null ? FG_CLOSED_QUERY : FG_CLOSED_QUERY_WITH_ID, this.geschlBr, this.toList(this.baCd).equals("null") ? "null" : "ARRAY[" + this.toList(this.baCd) + "]") : tables + " union " + String.format(this.baCd == null ? FG_CLOSED_QUERY : FG_CLOSED_QUERY_WITH_ID, this.geschlBr, this.toList(this.baCd).equals("null") ? "null" : "ARRAY[" + this.toList(this.baCd) + "]");
                }
                if (this.see) {
                    tables = tables == null ? String.format(this.bbox == null ? SEE_QUERY_WITHOUT_GEO : SEE_QUERY, this.bbox) : tables + " union " + String.format(this.bbox == null ? SEE_QUERY_WITHOUT_GEO : SEE_QUERY, this.bbox);
                }
                if (this.seeKl) {
                    tables = tables == null ? String.format(this.bbox == null ? SEE_KL_QUERY_WITHOUT_GEO : SEE_KL_QUERY, this.bbox) : tables + " union " + String.format(this.bbox == null ? SEE_KL_QUERY_WITHOUT_GEO : SEE_KL_QUERY, this.bbox);
                }
                if (this.ostsee) {
                    tables = tables == null ? String.format(this.bbox == null ? OSTSEE_QUERY_WITHOUT_GEO : OSTSEE_QUERY, this.bbox) : tables + " union " + String.format(this.bbox == null ? OSTSEE_QUERY_WITHOUT_GEO : OSTSEE_QUERY, this.bbox);
                }
                String query = String.format(QUERY, tables);
                if (ms instanceof DomainServerImpl) {
                    try {
                        DomainServerImpl serv = (DomainServerImpl)ms;
                        Connection con = serv.getConnectionPool().getConnection(true);
                        Statement s = con.createStatement();
                        ResultSet rs = s.executeQuery(query);
                        ArrayList result = serv.collectResults(rs);
                        serv.getConnectionPool().releaseDbConnection(con);
                        return result;
                    }
                    catch (Exception e) {
                        String msg = "Error during sql statement: " + query;
                        LOG.error((Object)msg, (Throwable)e);
                        throw new RemoteException(msg, e);
                    }
                }
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    private String toList(String[] baCd) {
        if (baCd == null) {
            return "null";
        }
        StringBuffer sb = null;
        for (String tmp : baCd) {
            if (sb == null) {
                sb = new StringBuffer("'" + tmp + "'");
                continue;
            }
            sb.append(",").append("'").append(tmp).append("'");
        }
        return sb.toString();
    }

    private String toArrayString(Integer[] ids) {
        StringBuffer sb = null;
        Integer[] integerArray = ids;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tmp = integerArray[i];
            if (sb == null) {
                sb = new StringBuffer("ARRAY[" + tmp);
                continue;
            }
            sb.append(",").append(tmp);
        }
        sb.append("]");
        return sb.toString();
    }
}

