/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RouteProblemsCount
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(RouteProblemsCount.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select dlm25w.correction_count(%1$s, %2$s)";
    private static final String QUERY_WITH_CLASS = "select dlm25w.correction_count(%1$s, %2$s, %3$s, %4$s)";
    private String owner;
    private int[] ids;
    private int[] classIds = null;
    private boolean fgBakIds = true;

    public RouteProblemsCount(String owner, int[] ids) {
        this.owner = owner;
        this.ids = ids;
        if (owner != null) {
            this.owner = "'" + owner + "'";
        }
    }

    public RouteProblemsCount(String owner, int[] ids, int[] classIds, boolean fgBakIds) {
        this.owner = owner;
        this.ids = ids;
        this.classIds = classIds;
        this.fgBakIds = fgBakIds;
        if (owner != null) {
            this.owner = "'" + owner + "'";
        }
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                if (this.classIds != null) {
                    ArrayList lists = ms.performCustomSearch(String.format(QUERY_WITH_CLASS, this.owner, SQLFormatter.createSqlArrayString(this.ids), SQLFormatter.createSqlArrayString(this.classIds), String.valueOf(this.fgBakIds)));
                    return lists;
                }
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.owner, SQLFormatter.createSqlArrayString(this.ids)));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

