/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SeeReport
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(SeeReport.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select ST_LineLocatePoint(bg.geo_field, st_startPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field)))))  * st_length(bg.geo_field) von,\nST_LineLocatePoint(bg.geo_field, st_endPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field))))) * st_length(bg.geo_field) bis,\nuesg_name, wbbl, s.id, info\nfrom dlm25w.sg_detail s\njoin (select g.* from dlm25w.sg_detail s join geom g on (s.geom = g.id) limit 5000000) g on (s.geom = g.id),\ndlm25w.fg_ba b\njoin geom bg on (bg.id = b.geom)\nwhere b.ba_cd = '%s' and st_intersects(g.geo_field, bg.geo_field)\norder by least(ST_LineLocatePoint(bg.geo_field, st_startPoint(st_intersection(g.geo_field, bg.geo_field)))  * st_length(bg.geo_field),\nST_LineLocatePoint(bg.geo_field, st_endPoint(st_intersection(g.geo_field, bg.geo_field))) * st_length(bg.geo_field))";
    private static final String QUERYIds = "select least(von.wert, bis.wert) von, greatest(von.wert, bis.wert) bis, b.ba_cd, b.id, a.id as id\nfrom dlm25w.fg_ba_anll a join dlm25w.k_anll k on (a.anll = k.id ) join dlm25w.fg_ba_linie l on (a.ba_st = l.id)\n\tjoin dlm25w.fg_ba_punkt von on (von.id = l.von) join dlm25w.fg_ba_punkt bis on (bis.id = l.bis)\n\tjoin dlm25w.fg_ba b on (von.route = b.id) join geom bg on (bg.id = b.geom)\nwhere b.id = any(%s) and k.name ilike 'See' \norder by least(von.wert, bis.wert), greatest(von.wert, bis.wert)";
    private String baCd = null;
    private int[] baIds = null;

    public SeeReport(String baCd) {
        this.baCd = baCd;
    }

    public SeeReport(int[] baIds) {
        this.baIds = baIds;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = this.baIds != null ? String.format(QUERYIds, SQLFormatter.createSqlArrayString(this.baIds)) : String.format(QUERY, this.baCd);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

