/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.sql.DBConnectionPool;
import de.cismet.commons.concurrency.CismetExecutors;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DbUpdater {
    private static final Logger LOG = Logger.getLogger(DbUpdater.class);
    private final List<String> updates = new ArrayList<String>();
    private final DBConnectionPool connectionPool;

    public DbUpdater(DBConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void addUpdate(String cmd) {
        this.updates.add(cmd);
    }

    public void execute() {
        ExecutorService executor = CismetExecutors.newFixedThreadPool((int)this.updates.size());
        for (String command : this.updates) {
            executor.execute(new DBExecutor(command));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updates.clear();
    }

    private class DBExecutor
    implements Runnable {
        private final String command;

        public DBExecutor(String command) {
            this.command = command;
        }

        @Override
        public void run() {
            Connection con = null;
            try {
                con = DbUpdater.this.connectionPool.getLongTermConnection();
                Statement s = con.createStatement();
                s.execute(this.command);
            }
            catch (SQLException ex) {
                LOG.error((Object)("Error while executing the following sql command: " + this.command), (Throwable)ex);
            }
            finally {
                if (con != null) {
                    DbUpdater.this.connectionPool.releaseDbConnection(con);
                }
            }
        }
    }
}

