/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DuevTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger log = Logger.getLogger(DuevTrigger.class);
    private static final String FG_BA_DUV_CLASS_NAME = "de.cismet.cids.dynamics.duv.fg_ba_duv";
    private static final String FG_BA_DUV_TABLE_NAME = "duv.fg_ba_duv";

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", FG_BA_DUV_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isDuevObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BA_DUV_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restat(final CidsBean cidsBean, User user) {
        if (this.isDuevObject(cidsBean)) {
            Connection con = null;
            try {
                long start = System.currentTimeMillis();
                final Object id = cidsBean.getProperty("id");
                if (id != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Connection con = null;
                            try {
                                con = DuevTrigger.this.getDbServer().getConnectionPool().getConnection(true);
                                Statement s = con.createStatement();
                                s.execute("select duv.recreate_duv('" + id + "')");
                            }
                            catch (Exception e) {
                                log.error((Object)("Error while executing async duew trigger." + String.valueOf(cidsBean.getMetaObject().getID())), (Throwable)e);
                            }
                            finally {
                                if (con != null) {
                                    DuevTrigger.this.getDbServer().getConnectionPool().releaseDbConnection(con);
                                }
                            }
                        }
                    });
                    t.start();
                    log.error((Object)("time to update duv " + (System.currentTimeMillis() - start)));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while executing lfk trigger.", (Throwable)e);
            }
            finally {
                if (con != null) {
                    this.getDbServer().getConnectionPool().releaseDbConnection(con);
                }
            }
        }
    }
}

