/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EzgDetailTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger LOG = Logger.getLogger(EzgDetailTrigger.class);
    private static final String EZG_DETAIL_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.ezg_detail";
    private static final String EZG_DETAIL_NAME = "dlm25w.ezg_detail";
    private static final ThreadPoolExecutor SINGLE_THREAD_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", EZG_DETAIL_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isEzgMvWbvJahrObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(EZG_DETAIL_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    private void restat(CidsBean cidsBean, User user) {
        if (this.isEzgMvWbvJahrObject(cidsBean) && SINGLE_THREAD_EXECUTOR.getPoolSize() < 2) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Connection con = null;
                    try {
                        con = EzgDetailTrigger.this.getDbServer().getConnectionPool().getLongTermConnection();
                        Statement s = con.createStatement();
                        s.execute("select dlm25w.import_ezg_mv_rbd()");
                        s.execute("select dlm25w.import_ezg_mv_wa()");
                        s.execute("select dlm25w.import_ezg_mv_planu()");
                        s.execute("select dlm25w.import_ezg_mv_detail()");
                        s.execute("select dlm25w.import_kg_zonen_f()");
                        s.execute("select dlm25w.import_kg_zonen_l()");
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while executing async ezgMvWbvJahr trigger.", (Throwable)e);
                    }
                    finally {
                        if (con != null) {
                            EzgDetailTrigger.this.getDbServer().getConnectionPool().releaseDbConnection(con);
                        }
                    }
                }
            };
            SINGLE_THREAD_EXECUTOR.execute(r);
        }
    }
}

