/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FgLakAeTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger log = Logger.getLogger(FgLakAeTrigger.class);
    private static final String FG_BAK_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_lak_ae";
    private static final String FG_BAK_GWK_TABLE_NAME = "dlm25w.fg_lak_ae";

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", FG_BAK_GWK_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isFgBakObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BAK_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restat(CidsBean cidsBean, User user) {
        if (!this.isFgBakObject(cidsBean)) return;
        Connection con = null;
        try {
            long start = System.currentTimeMillis();
            Object id = cidsBean.getProperty("lak_st.von.route.id");
            Object la_cd = cidsBean.getProperty("lak_st.von.route.la_cd.la_cd");
            if (id != null) {
                con = this.getDbServer().getConnectionPool().getLongTermConnection();
                Statement s = con.createStatement();
                s.execute("select dlm25w.import_fg_la(" + la_cd.toString() + ", '" + user.getName() + "')");
                s.execute("select dlm25w.replace_fg_la(id) from dlm25w.fg_la where la_cd = " + la_cd.toString());
                s.execute("select dlm25w.add_fg_la_stat_by_lak(" + id.toString() + ")");
                s.execute("select dlm25w.add_fg_la_stat_10_by_lak(" + id.toString() + ")");
                s.execute("select dlm25w.import_fg_la_pr_pf(l.id, '" + user.getName() + "') from dlm25w.fg_la l join dlm25w.k_gwk_lawa k on (k.id = l.la_cd) where k.la_cd = " + la_cd.toString());
                log.error((Object)("time to update stations " + (System.currentTimeMillis() - start)));
            }
            if (con == null) return;
        }
        catch (Exception e) {
            log.error((Object)"Error while executing fgLakAe trigger.", (Throwable)e);
            return;
        }
        finally {
            if (con != null) {
                this.getDbServer().getConnectionPool().releaseDbConnection(con);
            }
        }
        this.getDbServer().getConnectionPool().releaseDbConnection(con);
        return;
    }
}

