/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FotoTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger log = Logger.getLogger(FotoTrigger.class);
    private static final String FG_BAK_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.foto";
    private static final String FG_BAK_TABLE_NAME = "dlm25w.foto";

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", FG_BAK_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isFgBakObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BAK_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restat(CidsBean cidsBean, User user) {
        if (!this.isFgBakObject(cidsBean)) return;
        Connection con = null;
        try {
            Integer id = cidsBean.getMetaObject().getID();
            Object fotoNr = cidsBean.getProperty("foto_nr");
            con = this.getDbServer().getConnectionPool().getConnection(true);
            Statement s = con.createStatement();
            if (fotoNr instanceof Integer) {
                s.execute("select dlm25w.import_fg_ba_foto_pr_pfById(" + fotoNr.toString() + ", '" + user.getName() + "')");
            }
            if (con == null) return;
        }
        catch (Exception e) {
            log.error((Object)"Error while executing foto trigger.", (Throwable)e);
            return;
        }
        finally {
            if (con != null) {
                this.getDbServer().getConnectionPool().releaseDbConnection(con);
            }
        }
        this.getDbServer().getConnectionPool().releaseDbConnection(con);
        return;
    }
}

