/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import de.cismet.watergisserver.trigger.DbUpdater;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class HnTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger LOG = Logger.getLogger(HnTrigger.class);
    private static final String HN_CLASS_NAME = "de.cismet.cids.dynamics.duv.hn1";
    private static final String HN_TABLE_NAME = "duv.hn";
    private static Geometry beforeInsert;

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeUpdate(CidsBean cidsBean, User user) {
        if (this.isHnObject(cidsBean)) {
            int id = cidsBean.getMetaObject().getID();
            Connection con = null;
            try {
                Statement st;
                ResultSet rs;
                if (id > 0 && (rs = (st = (con = this.getDbServer().getConnectionPool().getConnection(true)).createStatement()).executeQuery("select st_asBinary(geom) from duv.fb where id = " + id)).next()) {
                    GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), -1);
                    WKBReader wkbReader = new WKBReader(geomFactory);
                    byte[] geometryAsByteArray = (byte[])rs.getObject(1);
                    if (geometryAsByteArray != null) {
                        beforeInsert = wkbReader.read(geometryAsByteArray);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while executing fb beforeUpdate trigger." + String.valueOf(id)), (Throwable)e);
            }
            finally {
                if (con != null) {
                    this.getDbServer().getConnectionPool().releaseDbConnection(con);
                }
            }
        }
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey("ALLOFTHEM", HN_TABLE_NAME);
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isHnObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(HN_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restat(CidsBean cidsBean, User user) {
        if (this.isHnObject(cidsBean)) {
            Connection con = null;
            try {
                long start = System.currentTimeMillis();
                Object id = cidsBean.getProperty("id");
                Geometry g = (Geometry)cidsBean.getProperty("geom");
                if (g != null) {
                    DbUpdater updater = new DbUpdater(this.getDbServer().getConnectionPool());
                    updater.addUpdate("select duv.recreate_hn('" + g + "', '" + beforeInsert + "')");
                    updater.execute();
                    LOG.error((Object)("time to update fb " + (System.currentTimeMillis() - start)));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while executing lfk trigger.", (Throwable)e);
            }
            finally {
                if (con != null) {
                    this.getDbServer().getConnectionPool().releaseDbConnection(con);
                }
            }
        }
    }
}

