/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.trigger;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import de.cismet.watergisserver.trigger.DbUpdater;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class RlDDueTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger log = Logger.getLogger(RlDDueTrigger.class);
    private static final String FG_BA_RL_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_ba_rl";
    private static final String FG_BA_RL_TABLE_NAME = "duv.fg_ba_rl";
    private static final String FG_BA_D_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_ba_d";
    private static final String FG_BA_D_TABLE_NAME = "duv.fg_ba_d";
    private static final String FG_BA_DUE_CLASS_NAME = "de.cismet.cids.dynamics.dlm25w.fg_ba_due";
    private static final String FG_BA_DUE_TABLE_NAME = "duv.fg_ba_due";

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public CidsTriggerKey getTriggerKey() {
        return CidsTriggerKey.FORALL;
    }

    public int compareTo(CidsTrigger o) {
        return 0;
    }

    private boolean isDuevObject(CidsBean cidsBean) {
        return cidsBean.getClass().getName().equals(FG_BA_D_CLASS_NAME) || cidsBean.getClass().getName().equals(FG_BA_DUE_CLASS_NAME) || cidsBean.getClass().getName().equals(FG_BA_RL_CLASS_NAME);
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.restat(cidsBean, user);
    }

    private void restat(final CidsBean cidsBean, User user) {
        if (this.isDuevObject(cidsBean)) {
            Thread t = new Thread("recreate duv"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Connection con = null;
                    try {
                        long start = System.currentTimeMillis();
                        Object id = cidsBean.getProperty("ba_st.von.route.id");
                        if (id != null) {
                            DbUpdater updater = new DbUpdater(RlDDueTrigger.this.getDbServer().getConnectionPool());
                            updater.addUpdate("select duv.recreate_fg_ba_duvByFg(" + id + ")");
                            updater.execute();
                            log.error((Object)("time to update duv by FG " + (System.currentTimeMillis() - start)));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while executing rl/d/due trigger.", (Throwable)e);
                    }
                    finally {
                        if (con != null) {
                            RlDDueTrigger.this.getDbServer().getConnectionPool().releaseDbConnection(con);
                        }
                    }
                }
            };
            t.start();
        }
    }
}

