/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.helper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ActionHelper {
    private static final String QUOTE_IDENTIFIER = "select quote_ident(?)";
    public static final String[] INVALID_DB_USER = new String[]{"postgres", "rep_admin", "user_ro"};
    public static final String[] INVALID_SCHEMAS = new String[]{"dlm25w", "public", "duv", "ogc", "raw", "pg_catalog", "information_schema"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quoteIdentifier(Connection con, String identifier) throws Exception {
        String result = null;
        PreparedStatement psCreate = null;
        ResultSet rs = null;
        try {
            psCreate = con.prepareStatement(QUOTE_IDENTIFIER);
            psCreate.setString(1, identifier);
            rs = psCreate.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            String string = result;
            return string;
        }
        finally {
            if (psCreate != null) {
                psCreate.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    public static boolean isInvalidSchemaName(String schemaName) {
        return ActionHelper.arrayContainsString(INVALID_SCHEMAS, schemaName) || schemaName.toLowerCase().startsWith("pg_");
    }

    public static boolean isInvalidUserName(String user) {
        return ActionHelper.arrayContainsString(INVALID_DB_USER, user) || user.toLowerCase().startsWith("pg_");
    }

    private static boolean arrayContainsString(String[] array, String string) {
        for (String entry : array) {
            if (!entry.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

