/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.helper;

import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class CompressedGeometry
implements Serializable {
    private static final Logger LOG = Logger.getLogger(CompressedGeometry.class);
    private byte[] compressedGeometry;

    public CompressedGeometry(Geometry geom) {
        try {
            ByteArrayOutputStream iout = new ByteArrayOutputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(iout);
            oout.writeObject(geom);
            oout.flush();
            GZIPOutputStream zstream = new GZIPOutputStream(bout);
            zstream.write(iout.toByteArray());
            zstream.finish();
            this.compressedGeometry = bout.toByteArray();
        }
        catch (Exception e) {
            LOG.error((Object)"error while compressing.-", (Throwable)e);
        }
    }

    public Geometry getGeometry() throws Exception {
        GZIPInputStream gzipIn = new GZIPInputStream(new ByteArrayInputStream(this.compressedGeometry));
        ObjectInputStream uncompressedIn = new ObjectInputStream(gzipIn);
        return (Geometry)uncompressedIn.readObject();
    }
}

