/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CreateSchemaAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(CreateSchemaAction.class);
    private static final String CREATE_SCHEMA = "CREATE SCHEMA %1s";
    private static final String ADD_PERMISSION = "GRANT USAGE ON SCHEMA %1s TO %1s";
    public static final String TASK_NAME = "createSchema";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Connection con;
        DomainServerImpl domainServer;
        block13: {
            Boolean bl2;
            block12: {
                domainServer = null;
                con = null;
                try {
                    String schemaName = null;
                    String dbUser = null;
                    for (ServerActionParameter param : params) {
                        if (ParameterType.SCHEMA.toString().equals(param.getKey())) {
                            schemaName = (String)param.getValue();
                        }
                        if (!ParameterType.DB_USER.toString().equals(param.getKey())) continue;
                        dbUser = (String)param.getValue();
                    }
                    if (ActionHelper.isInvalidUserName(dbUser)) {
                        Boolean bl3 = false;
                        return bl3;
                    }
                    if (ActionHelper.isInvalidSchemaName(schemaName)) {
                        bl2 = false;
                        if (domainServer == null) return bl2;
                        if (con == null) return bl2;
                        break block12;
                    }
                    domainServer = (DomainServerImpl)this.metaService;
                    con = domainServer.getConnectionPool().getLongTermConnection();
                    String string = ActionHelper.quoteIdentifier(con, schemaName);
                    String quotedDbUser = ActionHelper.quoteIdentifier(con, dbUser);
                    Statement st = con.createStatement();
                    st.executeUpdate(String.format(CREATE_SCHEMA, string));
                    st.executeUpdate(String.format(ADD_PERMISSION, string, quotedDbUser));
                    st.close();
                    bl = true;
                    if (domainServer == null) return bl;
                    break block13;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating schema", (Throwable)e);
                    Boolean bl4 = false;
                    return bl4;
                }
            }
            domainServer.getConnectionPool().releaseDbConnection(con);
            return bl2;
        }
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        SCHEMA,
        DB_USER;

    }
}

