/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CreateUserAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(CreateUserAction.class);
    private static final String CREATE_USER = "CREATE ROLE %1s WITH\n  LOGIN\n  NOSUPERUSER\n  INHERIT\n  NOCREATEDB\n  NOCREATEROLE\n  NOREPLICATION  \n  PASSWORD '%2s';";
    public static final String TASK_NAME = "createUser";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        Boolean bl;
        Statement psCreate;
        Connection con;
        DomainServerImpl domainServer;
        block21: {
            block22: {
                Boolean bl2;
                block19: {
                    block20: {
                        domainServer = null;
                        con = null;
                        psCreate = null;
                        try {
                            String dbUser = null;
                            String dbPassword = null;
                            for (ServerActionParameter param : params) {
                                if (ParameterType.DB_USER.toString().equals(param.getKey())) {
                                    dbUser = (String)param.getValue();
                                }
                                if (!ParameterType.DB_PASSWORD.toString().equals(param.getKey())) continue;
                                dbPassword = (String)param.getValue();
                            }
                            if (ActionHelper.isInvalidUserName(dbUser)) {
                                bl2 = false;
                                if (psCreate == null) break block19;
                                break block20;
                            }
                            domainServer = (DomainServerImpl)this.metaService;
                            con = domainServer.getConnectionPool().getLongTermConnection();
                            String string = ActionHelper.quoteIdentifier(con, dbUser);
                            Statement st = con.createStatement();
                            st.executeUpdate(String.format(CREATE_USER, string, dbPassword));
                            st.close();
                            bl = true;
                            if (psCreate == null) break block21;
                            break block22;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while creating user", (Throwable)e);
                            Boolean bl3 = false;
                            return bl3;
                        }
                    }
                    try {
                        psCreate.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (domainServer == null) return bl2;
                if (con == null) return bl2;
                domainServer.getConnectionPool().releaseDbConnection(con);
                return bl2;
            }
            try {
                psCreate.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (domainServer == null) return bl;
        if (con == null) return bl;
        domainServer.getConnectionPool().releaseDbConnection(con);
        return bl;
        finally {
            if (psCreate != null) {
                try {
                    psCreate.close();
                }
                catch (SQLException sQLException) {}
            }
            if (domainServer != null && con != null) {
                domainServer.getConnectionPool().releaseDbConnection(con);
            }
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        DB_USER,
        DB_PASSWORD;

    }
}

