/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import de.cismet.cids.custom.watergis.server.actions.TemplateRefresher;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RefreshTemplateAction
implements ServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(RefreshTemplateAction.class);
    public static final String DRAIN_BASIN = "RefreshDrainBasin";
    public static final String RW_SEG_GEOM = "RefreshRwSegGeom";
    public static final String EZG_K_RL = "RefreshEzgKrl";
    public static final String TASK_NAME = "RefreshTemplate";
    private MetaService metaService;

    public void setMetaService(MetaService ms) {
        this.metaService = ms;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        DomainServerImpl domainServer;
        String template = null;
        String wait = "false";
        for (ServerActionParameter param : params) {
            if (ParameterType.TEMPLATE.toString().equals(param.getKey())) {
                template = (String)param.getValue();
                continue;
            }
            if (!ParameterType.WAIT.toString().equals(param.getKey())) continue;
            wait = (String)param.getValue();
        }
        if (wait != null && wait.equalsIgnoreCase("true")) {
            domainServer = (DomainServerImpl)this.metaService;
            if (template != null && template.equals(DRAIN_BASIN)) {
                Connection con = null;
                try {
                    try {
                        con = domainServer.getConnectionPool().getLongTermConnection();
                        Statement statement = con.createStatement();
                        statement.execute("select dlm25w.refreshDrainBasin()");
                        statement.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Cannot refresh drainBasin", (Throwable)ex);
                    }
                }
                finally {
                    if (con != null) {
                        domainServer.getConnectionPool().releaseDbConnection(con);
                    }
                }
            } else if (template != null && template.equals(RW_SEG_GEOM)) {
                Connection con = null;
                try {
                    try {
                        con = domainServer.getConnectionPool().getLongTermConnection();
                        Statement statement = con.createStatement();
                        statement.execute("select dlm25w.refreshRwSegGeom()");
                        statement.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Cannot refresh drainBasin", (Throwable)ex);
                    }
                }
                finally {
                    if (con != null) {
                        domainServer.getConnectionPool().releaseDbConnection(con);
                    }
                }
            } else if (template != null && template.equals(EZG_K_RL)) {
                Connection con = null;
                try {
                    try {
                        con = domainServer.getConnectionPool().getLongTermConnection();
                        Statement statement = con.createStatement();
                        statement.execute("select dlm25w.refreshSEzgKRl()");
                        statement.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"Cannot refresh drainBasin", (Throwable)ex);
                    }
                }
                finally {
                    if (con != null) {
                        domainServer.getConnectionPool().releaseDbConnection(con);
                    }
                }
            }
        } else {
            domainServer = (DomainServerImpl)this.metaService;
            if (template != null && template.equals(DRAIN_BASIN)) {
                TemplateRefresher.getInstance().refreshDrainBasin(domainServer.getConnectionPool());
            } else if (template != null && template.equals(RW_SEG_GEOM)) {
                TemplateRefresher.getInstance().refreshRwSegGm(domainServer.getConnectionPool());
            } else if (template != null && template.equals(EZG_K_RL)) {
                TemplateRefresher.getInstance().refreshEzgKrl(domainServer.getConnectionPool());
            }
        }
        return true;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum ParameterType {
        TEMPLATE,
        WAIT;

    }
}

