/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.actions;

import Sirius.server.sql.DBConnectionPool;
import de.cismet.cids.custom.watergis.server.actions.RefreshTemplateAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TemplateRefresher {
    private static final Logger LOG = Logger.getLogger(RefreshTemplateAction.class);
    private ThreadPoolExecutor drainBasinExecuter = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private ThreadPoolExecutor rwseggeomExecuter = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private ThreadPoolExecutor ezgKrlExecuter = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    private TemplateRefresher() {
    }

    public static TemplateRefresher getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void refreshDrainBasin(final DBConnectionPool dbPool) {
        if (this.drainBasinExecuter.getQueue().size() < 2) {
            this.drainBasinExecuter.submit(new Runnable(){

                @Override
                public void run() {
                    Connection con = null;
                    try {
                        try {
                            con = dbPool.getLongTermConnection();
                            Statement statement = con.createStatement();
                            statement.execute("select dlm25w.refreshDrainBasin()");
                            statement.close();
                        }
                        catch (SQLException ex) {
                            LOG.error((Object)"Cannot refresh drainBasin", (Throwable)ex);
                        }
                    }
                    finally {
                        if (dbPool != null && con != null) {
                            dbPool.releaseDbConnection(con);
                        }
                    }
                }
            });
        }
    }

    public void refreshRwSegGm(final DBConnectionPool dbPool) {
        if (this.rwseggeomExecuter.getQueue().size() < 2) {
            this.rwseggeomExecuter.submit(new Runnable(){

                @Override
                public void run() {
                    Connection con = null;
                    try {
                        try {
                            con = dbPool.getLongTermConnection();
                            Statement statement = con.createStatement();
                            statement.execute("select dlm25w.refreshRwSegGeom()");
                            statement.close();
                        }
                        catch (SQLException ex) {
                            LOG.error((Object)"Cannot refresh RwSegGeom", (Throwable)ex);
                        }
                    }
                    finally {
                        if (dbPool != null && con != null) {
                            dbPool.releaseDbConnection(con);
                        }
                    }
                }
            });
        }
    }

    public void refreshEzgKrl(final DBConnectionPool dbPool) {
        if (this.ezgKrlExecuter.getQueue().size() < 2) {
            this.ezgKrlExecuter.submit(new Runnable(){

                @Override
                public void run() {
                    Connection con = null;
                    try {
                        try {
                            con = dbPool.getLongTermConnection();
                            Statement statement = con.createStatement();
                            statement.execute("select dlm25w.refreshSEzgKRl()");
                            statement.close();
                        }
                        catch (SQLException ex) {
                            LOG.error((Object)"Cannot refresh ezgKrl", (Throwable)ex);
                        }
                    }
                    finally {
                        if (dbPool != null && con != null) {
                            dbPool.releaseDbConnection(con);
                        }
                    }
                }
            });
        }
    }

    private static final class LazyInitialiser {
        private static final TemplateRefresher INSTANCE = new TemplateRefresher();

        private LazyInitialiser() {
        }
    }
}

