/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class DetermineClosestRoute
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(DetermineClosestRoute.class);
    private static final String SUITABLE_ROUTE_QUERY = "select %2$s.%1$s from %2$s join geom on (geom = geom.id) order by st_distance(geo_field, '%3$s') asc limit 1;";
    public static final String DOMAIN_NAME = "DLM25W";
    private final Integer routeClass;
    private final String primaryKey;
    private final String tableName;
    private final String firstPointAsText;

    public DetermineClosestRoute(Integer routeClass, String primaryKey, String tableName, String firstPointAsText) {
        this.routeClass = routeClass;
        this.primaryKey = primaryKey;
        this.tableName = tableName;
        this.firstPointAsText = firstPointAsText;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                Object o;
                ArrayList subList;
                String query = String.format(SUITABLE_ROUTE_QUERY, this.primaryKey, this.tableName, this.firstPointAsText);
                ArrayList lists = ms.performCustomSearch(query);
                if (lists != null && lists.size() > 0 && (subList = (ArrayList)lists.get(0)) != null && subList.size() > 0 && (o = subList.get(0)) instanceof Integer) {
                    MetaObject route = ms.getMetaObject(this.getUser(), ((Integer)o).intValue(), this.routeClass.intValue());
                    ArrayList<MetaObject> result = new ArrayList<MetaObject>();
                    result.add(route);
                    return result;
                }
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

