/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class GmdNameByNumber
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(GmdNameByNumber.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select gmd_name from dlm25w.vw_alk_gmd where gmd_nr = %1$s";
    private final int gmd;

    public GmdNameByNumber(int gmd) {
        this.gmd = gmd;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = String.format(QUERY, this.gmd);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

