/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class LawaConnected
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(LawaConnected.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String CONNECTION_QUERY = "select (row_number() over ())::integer, a.*\nfrom (select unnest(array_agg(\n  st_asBinary(ST_LineSubstring(geo_field, least(von.wert, bis.wert) / st_length(geo_field), \n  case when (greatest(bis.wert, von.wert) / st_length(geo_field)) <= 1.0 then (greatest(bis.wert, von.wert) / st_length(geo_field)) else 1.0 end)\n))), k.la_cd\nfrom dlm25w.fg_bak_gwk gwk \njoin dlm25w.fg_bak_linie linie on (gwk.bak_st = linie.id) \njoin dlm25w.fg_bak_punkt von on (linie.von = von.id) \njoin dlm25w.fg_bak_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_bak bak on (von.route = bak.id) \nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)join geom on (bak.geom = geom.id) \nleft join dlm25w.k_gwk_lawa  k on (gwk.la_cd = k.id)\nwhere (gr.owner = %1$s or %1$s is null)group by k.la_cd\nhaving st_geometrytype(dlm25w.line_merge((array_agg(ST_LineSubstring(\ngeo_field, \nleast(von.wert, bis.wert) / st_length(geo_field), \ncase when (greatest(bis.wert, von.wert) / st_length(geo_field)) <= 1.0 then (greatest(bis.wert, von.wert) / st_length(geo_field)) else 1.0 end\n) )), 0.01)) <> 'ST_LineString'\norder by la_cd) a";
    private String owner;

    public LawaConnected(String owner) {
        this.owner = owner;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                this.owner = this.owner == null ? "null" : "'" + this.owner + "'";
                String query = String.format(CONNECTION_QUERY, this.owner);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

