/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class LawaDirection
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(LawaDirection.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String DIRECTION_QUERY = "select unnest(array_agg((st_asBinary(geo_field)))), (select kl.la_cd from dlm25w.k_gwk_lawa kl where kl.id = gwk.la_cd)::text\nfrom dlm25w.fg_bak_gwk gwk \njoin dlm25w.fg_bak_linie linie on (gwk.bak_st = linie.id) \njoin dlm25w.fg_bak_punkt von on (linie.von = von.id)\njoin dlm25w.fg_bak_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_bak bak on (von.route = bak.id) \nleft join dlm25w.k_ww_gr gr on (gr.id = bak.ww_gr)join geom on (bak.geom = geom.id) \nwhere (gr.owner = %1$s or %1$s is null)group by gwk.la_cd\nhaving count(bak.id) > 1 and st_geometryType(dlm25w.line_merge(array_agg( st_linesubstring(geo_field, least(von.wert, bis.wert) / st_length(geo_field),  case when (greatest(bis.wert, von.wert) / st_length(geo_field)) <= 1.0 then  (greatest(bis.wert, von.wert) / st_length(geo_field)) else 1.0 end)), 0.01)) = 'ST_LineString' \nand not dlm25w.contains_lines_in_same_direction(dlm25w.line_merge(array_agg( st_linesubstring(geo_field, least(von.wert, bis.wert) / st_length(geo_field),  case when (greatest(bis.wert, von.wert) / st_length(geo_field)) <= 1.0 then (greatest(bis.wert, von.wert) / st_length(geo_field)) else 1.0 end)), 0.01),  ST_Collect(st_linesubstring(geo_field, least(von.wert, bis.wert) / st_length(geo_field),  case when (greatest(bis.wert, von.wert) / st_length(geo_field)) <= 1.0 then (greatest(bis.wert, von.wert) / st_length(geo_field)) else 1.0 end))) \norder by la_cd";
    private String owner;

    public LawaDirection(String owner) {
        this.owner = owner;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                this.owner = this.owner == null ? "null" : "'" + this.owner + "'";
                String query = String.format(DIRECTION_QUERY, this.owner);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

