/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PhotoGetBaStat
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(PhotoGetBaStat.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select ba.id, ba_cd, round((ST_LineLocatePoint(geo_field, '%1$s') * st_length(geo_field))::numeric, 2)::double precision as stat,st_asBinary(ST_lineinterpolatepoint(geo_field, round((ST_LineLocatePoint(geo_field, '%1$s') * st_length(geo_field))::numeric, 2)::double precision  / st_length(geo_field) )) as point from\n(select ba.id, ba_cd, geo_field from dlm25w.fg_ba ba join geom on (geom = geom.id) \nwhere st_distance(geo_field, '%1$s') <= %2$s\norder by st_distance(geo_field, '%1$s') asc\nlimit 1) ba";
    private final Geometry geom;
    private final double maxDist;

    public PhotoGetBaStat(Geometry geom, double maxDist) {
        this.geom = geom;
        this.maxDist = maxDist;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.geom.toText(), this.maxDist));
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

