/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class QpWwgrByNr
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(QpWwgrByNr.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "Select gr.id from dlm25w.qp q join dlm25w.k_ww_gr gr on (q.ww_gr = gr.id) where qp_nr = %s";
    private final String qpNr;

    public QpWwgrByNr(String qpNr) {
        this.qpNr = qpNr;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                MetaClass mc = ms.getClassByTableName(this.getUser(), "dlm25w.k_ww_gr");
                ArrayList lists = ms.performCustomSearch(String.format(QUERY, this.qpNr));
                if (lists != null && lists.size() > 0 && lists.get(0) != null && ((ArrayList)lists.get(0)).size() > 0) {
                    MetaObject route = ms.getMetaObject(this.getUser(), ((Integer)((ArrayList)lists.get(0)).get(0)).intValue(), mc.getId());
                    ArrayList<MetaObject> result = new ArrayList<MetaObject>();
                    result.add(route);
                    return result;
                }
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

