/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RemoveUnnusedRoute
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(RemoveUnnusedRoute.class);
    public static final String DOMAIN_NAME = "DLM25W";
    public static final int FG_BA = 1;
    public static final int FG_LA = 2;
    public static final int FG_BAK = 3;
    public static final int FG_LAK = 4;
    public static final int SU = 5;
    public static final int FG_BA_DUV = 6;
    public static final int SG_UMRING = 7;
    private static final String QUERY_FGBA = "select dlm25w.remove_unused_fgbapoints(?)";
    private static final String QUERY_FGLA = "select dlm25w.remove_unused_fglapoints(?)";
    private static final String QUERY_FGBAK = "select dlm25w.remove_unused_fgbakpoints(?)";
    private static final String QUERY_FGLAK = "select dlm25w.remove_unused_fglakpoints(?)";
    private static final String QUERY_SU = "select dlm25w.remove_unused_supoints(?)";
    private static final String QUERY_FGBADUV = "select duv.remove_unused_fgbaduvpoints(?)";
    private static final String QUERY_SGUMRING = "select duv.remove_unused_sgumringpoints(?)";
    private final int id;
    private final int routeType;

    public RemoveUnnusedRoute(int id, int routeType) {
        this.id = id;
        this.routeType = routeType;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                PreparableStatement ps;
                switch (this.routeType) {
                    case 1: {
                        ps = new PreparableStatement(QUERY_FGBA, new int[]{4});
                        break;
                    }
                    case 3: {
                        ps = new PreparableStatement(QUERY_FGBAK, new int[]{4});
                        break;
                    }
                    case 2: {
                        ps = new PreparableStatement(QUERY_FGLA, new int[]{4});
                        break;
                    }
                    case 4: {
                        ps = new PreparableStatement(QUERY_FGLAK, new int[]{4});
                        break;
                    }
                    case 5: {
                        ps = new PreparableStatement(QUERY_SU, new int[]{4});
                        break;
                    }
                    case 6: {
                        ps = new PreparableStatement(QUERY_FGBADUV, new int[]{4});
                        break;
                    }
                    case 7: {
                        ps = new PreparableStatement(QUERY_SGUMRING, new int[]{4});
                        break;
                    }
                    default: {
                        ps = new PreparableStatement(QUERY_FGBA, new int[]{4});
                    }
                }
                ps.setObjects(new Object[]{this.id});
                ArrayList lists = ms.performCustomSearch(ps);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

