/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SchuUeberReport
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(SchuUeberReport.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY = "select ST_LineLocatePoint(bg.geo_field, st_startPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field)))))  * st_length(bg.geo_field) von,\nST_LineLocatePoint(bg.geo_field, st_endPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field))))) * st_length(bg.geo_field) bis,\nuesg_name, wbbl, recht, s.id\nfrom dlm25w.wr_sg_uesg s\njoin (select g.* from dlm25w.wr_sg_uesg s join geom g on (s.geom = g.id) limit 5000000) g on (s.geom = g.id),\ndlm25w.fg_ba b\njoin geom bg on (bg.id = b.geom)\nwhere b.ba_cd = '%s' and ST_IsValid(g.geo_field) and st_intersects(g.geo_field, bg.geo_field)\norder by least(ST_LineLocatePoint(bg.geo_field, st_startPoint(st_intersection(g.geo_field, bg.geo_field)))  * st_length(bg.geo_field),\nST_LineLocatePoint(bg.geo_field, st_endPoint(st_intersection(g.geo_field, bg.geo_field))) * st_length(bg.geo_field))";
    private static final String QUERYIds = "select ST_LineLocatePoint(bg.geo_field, st_startPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field)))))  * st_length(bg.geo_field) von,\nST_LineLocatePoint(bg.geo_field, st_endPoint(unnest(dlm25w.multi_geometry_to_array(st_intersection(g.geo_field, bg.geo_field))))) * st_length(bg.geo_field) bis,\nb.ba_cd, b.id, s.id\nfrom dlm25w.wr_sg_uesg s\njoin (select g.* from dlm25w.wr_sg_uesg s join geom g on (s.geom = g.id) limit 5000000) g on (s.geom = g.id),\ndlm25w.fg_ba b\njoin geom bg on (bg.id = b.geom)\nwhere b.id = any(%s) and ST_IsValid(g.geo_field) and st_intersects(g.geo_field, bg.geo_field)\norder by least(ST_LineLocatePoint(bg.geo_field, st_startPoint(st_intersection(g.geo_field, bg.geo_field)))  * st_length(bg.geo_field),\nST_LineLocatePoint(bg.geo_field, st_endPoint(st_intersection(g.geo_field, bg.geo_field))) * st_length(bg.geo_field))";
    private String baCd = null;
    private int[] baIds = null;

    public SchuUeberReport(String baCd) {
        this.baCd = baCd;
    }

    public SchuUeberReport(int[] baIds) {
        this.baIds = baIds;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                String query = this.baIds != null ? String.format(QUERYIds, SQLFormatter.createSqlArrayString(this.baIds)) : String.format(QUERY, this.baCd);
                ArrayList lists = ms.performCustomSearch(query);
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }
}

