/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.watergis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WsgStatSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(WsgStatSearch.class);
    public static final String DOMAIN_NAME = "DLM25W";
    private static final String QUERY_STAT = "select wsg_anz, wsg_fl from dlm25w.wr_sg_wsg_stat;";
    private static final String QUERY_FN = "select bodennutzu, st_area(geom) from dlm25w.wr_sg_wsg_fn;";
    private static final String QUERY_FORST = "select bft, st_area(geom) from dlm25w.wr_sg_wsg_forst;";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private boolean fn = true;

    public WsgStatSearch() {
    }

    public WsgStatSearch(boolean fn) {
        this.fn = fn;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get(DOMAIN_NAME);
        if (ms != null) {
            try {
                ArrayList tmp;
                ArrayList result = new ArrayList();
                ArrayList lists = ms.performCustomSearch(QUERY_STAT);
                if (lists != null && lists.size() > 0 && (tmp = (ArrayList)lists.get(0)) != null && tmp.size() > 1) {
                    result.add(tmp.get(0));
                    result.add(tmp.get(1));
                }
                if (this.fn) {
                    lists = ms.performCustomSearch(QUERY_FN);
                    Object af = null;
                    Object dgl = null;
                    if (lists != null && lists.size() > 0) {
                        for (ArrayList tmp2 : lists) {
                            if (tmp2 == null || tmp2.size() <= 1) continue;
                            if (tmp2.get(0) != null && tmp2.get(0).equals("AF")) {
                                af = tmp2.get(1);
                                continue;
                            }
                            if (tmp2.get(0) == null || !tmp2.get(0).equals("DGL")) continue;
                            dgl = tmp2.get(1);
                        }
                    }
                    result.add(af);
                    result.add(dgl);
                } else {
                    lists = ms.performCustomSearch(QUERY_FORST);
                    Double holzboden = 0.0;
                    Double nichtHolzboden = 0.0;
                    Double nichtEingerichtet = 0.0;
                    if (lists != null && lists.size() > 0) {
                        for (ArrayList tmp3 : lists) {
                            if (tmp3 == null || tmp3.size() <= 1) continue;
                            if (tmp3.get(0) != null && tmp3.get(0).equals("Holzboden")) {
                                holzboden = ((Number)tmp3.get(1)).doubleValue();
                                continue;
                            }
                            if (tmp3.get(0) != null && tmp3.get(0).equals("Nichtholzboden")) {
                                nichtHolzboden = ((Number)tmp3.get(1)).doubleValue();
                                continue;
                            }
                            if (tmp3.get(0) == null || !tmp3.get(0).equals("nicht eingerichtete Fl\u00e4che")) continue;
                            nichtEingerichtet = ((Number)tmp3.get(1)).doubleValue();
                        }
                    }
                    result.add(holzboden);
                    result.add(nichtHolzboden);
                    result.add(nichtEingerichtet);
                }
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.connectionContext = this.connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

