/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergisserver.cidslayer;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.watergisserver.cidslayer.WatergisDefaultCidsLayer;
import java.util.HashMap;
import java.util.Map;

public class Default1505ConsideredCidsLayer
extends WatergisDefaultCidsLayer {
    private static final String[] GREEN_WBV = new String[]{"01", "02", "04", "05", "08", "10", "11", "20", "28", "09"};
    private static final String[] EXCEPTION_THEMES = new String[]{"dlm25w.fg_bak_gn1", "dlm25w.fg_bak_wk", "dlm25w.fg_ba_1_ord"};

    public Default1505ConsideredCidsLayer(MetaClass mc, User user) {
        super(mc, user);
    }

    public Default1505ConsideredCidsLayer(MetaClass mc, User user, HashMap<String, String> CATALOGUE_NAME_MAP) {
        super(mc, CATALOGUE_NAME_MAP, user);
    }

    public Default1505ConsideredCidsLayer(MetaClass mc, User user, boolean showFgLa, boolean additionalGeom) {
        this(mc, user, showFgLa, additionalGeom, null);
    }

    public Default1505ConsideredCidsLayer(MetaClass mc, User user, boolean showFgLa, boolean additionalGeom, Map<String, String> catalogueNameMap) {
        super(mc, showFgLa, additionalGeom, catalogueNameMap, user);
    }

    public Default1505ConsideredCidsLayer(MetaClass mc, User user, boolean showFgLa, boolean additionalGeom, Map<String, String> catalogueNameMap, boolean inheritedWwGr, String additionalJoins) {
        super(mc, showFgLa, additionalGeom, catalogueNameMap, inheritedWwGr, additionalJoins, user);
    }

    @Override
    public String getRestriction() {
        if (this.user == null || this.user.getUserGroup().getName().equalsIgnoreCase("administratoren")) {
            return null;
        }
        boolean isGreenWbv = false;
        for (String greenWbv : GREEN_WBV) {
            if (!this.user.getUserGroup().getName().startsWith("wbv_" + greenWbv)) continue;
            isGreenWbv = true;
        }
        boolean isExceptionTheme = false;
        for (String et : EXCEPTION_THEMES) {
            if (!this.mc.getTableName().equalsIgnoreCase(et)) continue;
            isExceptionTheme = true;
        }
        if (isExceptionTheme) {
            return null;
        }
        if (this.user.getUserGroup().getName().startsWith("wbv_") && !isGreenWbv) {
            return " (dlm25wPk_ww_gr1.owner = '" + this.user.getUserGroup().getName() + "')";
        }
        return "(dlm25wPk_ww_gr1.wdm <> 1505 or dlm25wPk_ww_gr1.owner = '" + this.user.getUserGroup().getName() + "')";
    }
}

